package org.wildfly.nosql.common;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.util.ArrayList;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Collection;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-08-02T12:58:10-0400")
public class NoSQLLogger_$logger extends DelegatingBasicLogger implements NoSQLLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = NoSQLLogger_$logger.class.getName();
    public NoSQLLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void driverFailedToStop(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, cause, driverFailedToStop$str());
    }
    private static final String driverFailedToStop = "WFLYNOSQL0001: Failed to stop";
    protected String driverFailedToStop$str() {
        return driverFailedToStop;
    }
    private static final String cannotAddReferenceToModule = "WFLYNOSQL0002: Cannot specify NoSQL module '%s' when a different module '%s' is already associated with application (%s)";
    protected String cannotAddReferenceToModule$str() {
        return cannotAddReferenceToModule;
    }
    @Override
    public final IllegalStateException cannotAddReferenceToModule(final String module, final Object currentValue, final String deploymentName) {
        final IllegalStateException result = new IllegalStateException(String.format(cannotAddReferenceToModule$str(), module, currentValue, deploymentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void annotationAttributeMissing(final String annotation, final String attribute) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, annotationAttributeMissing$str(), annotation, attribute);
    }
    private static final String annotationAttributeMissing = "WFLYNOSQL0003: Ignored %s annotation, does not have %s.";
    protected String annotationAttributeMissing$str() {
        return annotationAttributeMissing;
    }
    private static final String unassignable = "WFLYNOSQL0004: Cannot unwrap class '%s'.";
    protected String unassignable$str() {
        return unassignable;
    }
    @Override
    public final IllegalArgumentException unassignable(final Class clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unassignable$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameter = "WFLYNOSQL0005: Cannot set %s to %s.  Instead set to one of %s";
    protected String invalidParameter$str() {
        return invalidParameter;
    }
    @Override
    public final OperationFailedException invalidParameter(final String transaction, final String str, final ArrayList arrayList) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidParameter$str(), transaction, str, arrayList));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringNamedQualifier(final String profile, final Collection<String> strings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, ignoringNamedQualifier$str(), profile, strings);
    }
    private static final String ignoringNamedQualifier = "WFLYNOSQL0006: Ignored @Inject @Named(%s), does not reference known NoSQL profile name. Known NoSQL profile names=%s";
    protected String ignoringNamedQualifier$str() {
        return ignoringNamedQualifier;
    }
    @Override
    public final void scannedNamedQualifier(final String profile, final String moduleName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, scannedNamedQualifier$str(), profile, moduleName);
    }
    private static final String scannedNamedQualifier = "WFLYNOSQL0007: Scanned @Inject @Named reference to NoSQL profile %s, which refers to NoSQL module %s";
    protected String scannedNamedQualifier$str() {
        return scannedNamedQualifier;
    }
    @Override
    public final void ignoringResourceLookup(final String lookup, final Collection<String> strings) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, ignoringResourceLookup$str(), lookup, strings);
    }
    private static final String ignoringResourceLookup = "WFLYNOSQL0008: Ignored @Resource lookup %s, does not reference known NoSQL jndi-name. Known NoSQL jndi-names=%s";
    protected String ignoringResourceLookup$str() {
        return ignoringResourceLookup;
    }
    @Override
    public final void scannedResourceLookup(final String lookup, final String moduleName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, scannedResourceLookup$str(), lookup, moduleName);
    }
    private static final String scannedResourceLookup = "WFLYNOSQL0009: Scanned @Resource lookup %s, which refers to NoSQL module %s";
    protected String scannedResourceLookup$str() {
        return scannedResourceLookup;
    }
}
