/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.nosql.common;

import java.util.Map;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.nosql.common.DriverScanDependencyProcessor;
import org.wildfly.nosql.common.NoSQLConstants;

public class DriverDependencyProcessor
implements DeploymentUnitProcessor {
    private static final DriverDependencyProcessor driverDependencyProcessor = new DriverDependencyProcessor();

    public static DriverDependencyProcessor getInstance() {
        return driverDependencyProcessor;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Map<String, String> nosqlDriverModuleNameMap = DriverScanDependencyProcessor.getPerDeploymentDeploymentModuleName(deploymentUnit);
        if (nosqlDriverModuleNameMap == null) {
            return;
        }
        for (String nosqlDriverModuleName : nosqlDriverModuleNameMap.values()) {
            if (nosqlDriverModuleName == null) continue;
            ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            this.addDependency(moduleSpecification, moduleLoader, ModuleIdentifier.fromString((String)nosqlDriverModuleName));
            this.addMongoCDIDependency(moduleSpecification, moduleLoader, nosqlDriverModuleName);
            this.addCassandraCDIDependency(moduleSpecification, moduleLoader, nosqlDriverModuleName);
            this.addNeo4jCDIDependency(moduleSpecification, moduleLoader, nosqlDriverModuleName);
            this.addOrientCDIDependency(moduleSpecification, moduleLoader, nosqlDriverModuleName);
        }
    }

    private void addMongoCDIDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        try {
            moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass(NoSQLConstants.MONGOCLIENTCLASS);
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        ModuleIdentifier mongoCDIExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.mongodb");
        this.addDependency(moduleSpecification, moduleLoader, mongoCDIExtensionModule);
    }

    private void addNeo4jCDIDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        try {
            moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("org.neo4j.driver.v1.Driver");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        ModuleIdentifier mongoCDIExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.neo4j");
        this.addDependency(moduleSpecification, moduleLoader, mongoCDIExtensionModule);
    }

    private void addCassandraCDIDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        try {
            moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.datastax.driver.core.Cluster");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        ModuleIdentifier mongoCDIExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.cassandra");
        this.addDependency(moduleSpecification, moduleLoader, mongoCDIExtensionModule);
    }

    private void addOrientCDIDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String nosqlDriverModuleName) {
        try {
            moduleLoader.loadModule(ModuleIdentifier.fromString((String)nosqlDriverModuleName)).getClassLoader().loadClass("com.orientechnologies.orient.core.db.OPartitionedDatabasePool");
        }
        catch (ClassNotFoundException expected) {
            return;
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("could not load NoSQL driver module " + nosqlDriverModuleName, e);
        }
        ModuleIdentifier mongoCDIExtensionModule = ModuleIdentifier.create((String)"org.wildfly.extension.nosql.orientdb");
        this.addDependency(moduleSpecification, moduleLoader, mongoCDIExtensionModule);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier ... moduleIdentifiers) {
        for (ModuleIdentifier moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

