/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.nosql.common;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class MethodHandleBuilder {
    private ClassLoader classLoader;
    private Class targetClass;
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();

    public MethodHandleBuilder classLoader(ModuleIdentifier moduleIdentifier) {
        Module module;
        try {
            module = Module.getBootModuleLoader().loadModule(moduleIdentifier);
        }
        catch (ModuleLoadException e) {
            throw new RuntimeException("Could not load module " + moduleIdentifier.getName(), e);
        }
        this.classLoader = module.getClassLoader();
        return this;
    }

    public MethodHandleBuilder className(String className) {
        if (this.classLoader == null) {
            throw new IllegalStateException("ClassLoader needs to be specified");
        }
        try {
            this.targetClass = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load " + className, e);
        }
        return this;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public MethodHandle method(String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = this.targetClass.getMethod(methodName, parameterTypes);
            return this.lookup.unreflect(method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get '" + methodName + "' method from " + this.targetClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get MethodHandle for '" + methodName + "' method from " + this.targetClass.getName(), e);
        }
    }

    public MethodHandle declaredMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = this.targetClass.getDeclaredMethod(methodName, parameterTypes);
            return this.lookup.unreflect(method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get '" + methodName + "' method from " + this.targetClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get MethodHandle for '" + methodName + "' method from " + this.targetClass.getName(), e);
        }
    }

    public MethodHandle declaredConstructor(Class<?> ... parameterTypes) {
        try {
            Constructor ctor = this.targetClass.getDeclaredConstructor(parameterTypes);
            return this.lookup.unreflectConstructor(ctor);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get constructor for " + this.targetClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get constructor MethodHandle for " + this.targetClass.getName(), e);
        }
    }

    public MethodHandle constructor(MethodType methodType) {
        try {
            return this.lookup.findConstructor(this.targetClass, methodType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get constructor for " + this.targetClass.getName() + " with MethodType " + methodType.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get constructor MethodHandle for " + this.targetClass.getName(), e);
        }
    }

    public MethodHandle staticField(String name) {
        try {
            Field field = this.targetClass.getField(name);
            return this.lookup.unreflectGetter(field);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not get static field " + name + " on class " + this.targetClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get static field " + name + " on class " + this.targetClass.getName(), e);
        }
    }

    public MethodHandle staticMethod(String name, MethodType methodType) {
        try {
            return this.lookup.unreflect(this.targetClass.getMethod(name, methodType.parameterArray()));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get static method " + name + " on class " + this.targetClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get static method " + name + " on class " + this.targetClass.getName(), e);
        }
    }
}

