/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectMethodFilter;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import com.orientechnologies.orient.object.serialization.OObjectLazyCustomSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class OObjectEntityEnhancer {
    private static final OObjectEntityEnhancer instance = new OObjectEntityEnhancer();
    private final Map<Class<?>, OObjectMethodFilter> customMethodFilters = new HashMap();
    private final OObjectMethodFilter defaultMethodFilter = new OObjectMethodFilter();
    public static final String ENHANCER_CLASS_PREFIX = "orientdb_";

    public <T> T getProxiedInstance(String iClass, OEntityManager entityManager, ODocument doc, ProxyObject parent, Object ... iArgs) {
        Class clazz = entityManager.getEntityClass(iClass);
        return this.getProxiedInstance((Class<T>)clazz, (Object)null, doc, parent, iArgs);
    }

    public <T> T getProxiedInstance(String iClass, Object iEnclosingInstance, OEntityManager entityManager, ODocument doc, ProxyObject parent, Object ... iArgs) {
        Class clazz = entityManager.getEntityClass(iClass);
        return this.getProxiedInstance(clazz, iEnclosingInstance, doc, parent, iArgs);
    }

    public <T> T getProxiedInstance(Class<T> iClass, ODocument doc, Object ... iArgs) {
        return this.getProxiedInstance(iClass, (Object)null, doc, null, iArgs);
    }

    public <T> T getProxiedInstance(Class<T> iClass, Object iEnclosingInstance, ODocument doc, ProxyObject parent, Object ... iArgs) {
        Class c;
        boolean isInnerClass;
        if (iClass == null) {
            throw new OSerializationException("Type '" + doc.getClassName() + "' cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        boolean bl = isInnerClass = OObjectEntitySerializer.getEnclosingClass(iClass) != null;
        if (Proxy.class.isAssignableFrom(iClass)) {
            c = iClass;
        } else {
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(iClass);
            if (this.customMethodFilters.get(iClass) != null) {
                f.setFilter((MethodFilter)this.customMethodFilters.get(iClass));
            } else {
                f.setFilter((MethodFilter)this.defaultMethodFilter);
            }
            c = f.createClass();
        }
        OObjectProxyMethodHandler mi = new OObjectProxyMethodHandler(doc);
        mi.setParentObject(parent);
        try {
            T newEntity;
            if (iArgs != null && iArgs.length > 0) {
                if (isInnerClass) {
                    if (iEnclosingInstance == null) {
                        iEnclosingInstance = iClass.getEnclosingClass().newInstance();
                    }
                    Object[] newArgs = new Object[iArgs.length + 1];
                    newArgs[0] = iEnclosingInstance;
                    for (int i = 0; i < iArgs.length; ++i) {
                        newArgs[i + 1] = iArgs[i];
                    }
                    iArgs = newArgs;
                }
                Constructor<?> constructor = null;
                for (Constructor<?> constr : c.getConstructors()) {
                    boolean found = true;
                    if (constr.getParameterTypes().length != iArgs.length) continue;
                    for (int i = 0; i < constr.getParameterTypes().length; ++i) {
                        Class<?> parameterType = constr.getParameterTypes()[i];
                        if (parameterType.isPrimitive()) {
                            if (this.isPrimitiveParameterCorrect(parameterType, iArgs[i])) continue;
                            found = false;
                            break;
                        }
                        if (iArgs[i] == null || parameterType.isAssignableFrom(iArgs[i].getClass())) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    constructor = constr;
                    break;
                }
                if (constructor != null) {
                    newEntity = constructor.newInstance(iArgs);
                    this.initDocument(iClass, newEntity, doc, (ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner());
                } else {
                    newEntity = iEnclosingInstance != null ? this.createInstanceNoParameters(c, iEnclosingInstance) : this.createInstanceNoParameters(c, iClass);
                }
            } else {
                newEntity = iEnclosingInstance != null ? this.createInstanceNoParameters(c, iEnclosingInstance) : this.createInstanceNoParameters(c, iClass);
            }
            ((Proxy)newEntity).setHandler((MethodHandler)mi);
            if (OObjectEntitySerializer.hasBoundedDocumentField(iClass)) {
                OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getBoundedDocumentField(iClass), newEntity, doc);
            }
            OObjectEntitySerializer.setVersionField(iClass, newEntity, doc.getVersion());
            return newEntity;
        }
        catch (InstantiationException ie) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)ie, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)iae, new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)iae, new Object[0]);
        }
        catch (SecurityException se) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)se, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)ite, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)nsme, new Object[0]);
        }
        return null;
    }

    public OObjectMethodFilter getMethodFilter(Class<?> iClass) {
        OObjectMethodFilter filter;
        if (Proxy.class.isAssignableFrom(iClass)) {
            iClass = iClass.getSuperclass();
        }
        if ((filter = this.customMethodFilters.get(iClass)) == null) {
            filter = this.defaultMethodFilter;
        }
        return filter;
    }

    public void registerClassMethodFilter(Class<?> iClass, OObjectMethodFilter iMethodFilter) {
        this.customMethodFilters.put(iClass, iMethodFilter);
    }

    public void deregisterClassMethodFilter(Class<?> iClass) {
        this.customMethodFilters.remove(iClass);
    }

    public static synchronized OObjectEntityEnhancer getInstance() {
        return instance;
    }

    private boolean isPrimitiveParameterCorrect(Class<?> primitiveClass, Object parameterValue) {
        if (parameterValue == null) {
            return false;
        }
        Class<?> parameterClass = parameterValue.getClass();
        if (Integer.TYPE.isAssignableFrom(primitiveClass)) {
            return Integer.class.isAssignableFrom(parameterClass);
        }
        if (Double.TYPE.isAssignableFrom(primitiveClass)) {
            return Double.class.isAssignableFrom(parameterClass);
        }
        if (Float.TYPE.isAssignableFrom(primitiveClass)) {
            return Float.class.isAssignableFrom(parameterClass);
        }
        if (Long.TYPE.isAssignableFrom(primitiveClass)) {
            return Long.class.isAssignableFrom(parameterClass);
        }
        if (Short.TYPE.isAssignableFrom(primitiveClass)) {
            return Short.class.isAssignableFrom(parameterClass);
        }
        if (Byte.TYPE.isAssignableFrom(primitiveClass)) {
            return Byte.class.isAssignableFrom(parameterClass);
        }
        return false;
    }

    protected void initDocument(Class<?> iClass, Object iInstance, ODocument iDocument, ODatabaseObject db) throws IllegalArgumentException, IllegalAccessException {
        for (Class<?> currentClass = iClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field f : currentClass.getDeclaredFields()) {
                OObjectLazyCustomSerializer o;
                if (f.getName().equals("this$0")) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((o = f.get(iInstance)) == null) continue;
                if (OObjectEntitySerializer.isSerializedType(f)) {
                    if (o instanceof List) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        iDocument.field(f.getName(), list);
                        o = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), (ORecord)iDocument, (List<Object>)list, o);
                        f.set(iInstance, o);
                        continue;
                    }
                    if (o instanceof Set) {
                        HashSet<Object> set = new HashSet<Object>();
                        iDocument.field(f.getName(), set);
                        o = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), (ORecord)iDocument, set, (Set)((Object)o));
                        f.set(iInstance, o);
                        continue;
                    }
                    if (o instanceof Map) {
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        iDocument.field(f.getName(), map);
                        o = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), (ORecord)iDocument, map, (Map)((Object)o));
                        f.set(iInstance, o);
                        continue;
                    }
                    o = OObjectEntitySerializer.serializeFieldValue(o.getClass(), o);
                    iDocument.field(f.getName(), (Object)o);
                    continue;
                }
                iDocument.field(f.getName(), OObjectEntitySerializer.typeToStream(o, OType.getTypeByClass(f.getType()), db, iDocument));
            }
        }
    }

    protected <T> T createInstanceNoParameters(Class<T> iProxiedClass, Class<?> iOriginalClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T instanceToReturn = null;
        Class<?> enclosingClass = OObjectEntitySerializer.getEnclosingClass(iOriginalClass);
        if (enclosingClass != null && !Modifier.isStatic(iOriginalClass.getModifiers())) {
            Object instanceOfEnclosingClass = this.createInstanceNoParameters(enclosingClass, enclosingClass);
            Constructor<T> ctor = iProxiedClass.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(instanceOfEnclosingClass);
            }
        } else {
            try {
                instanceToReturn = iProxiedClass.newInstance();
            }
            catch (InstantiationException e) {
                OLogManager.instance().error((Object)this, "Cannot create an instance of the enclosing class '%s'", new Object[]{iOriginalClass});
                throw e;
            }
        }
        return instanceToReturn;
    }

    protected <T> T createInstanceNoParameters(Class<T> iProxiedClass, Object iEnclosingInstance) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T instanceToReturn = null;
        Class<?> enclosingClass = iEnclosingInstance.getClass();
        if (enclosingClass != null) {
            Constructor<T> ctor = iProxiedClass.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(iEnclosingInstance);
            }
        } else {
            instanceToReturn = iProxiedClass.newInstance();
        }
        return instanceToReturn;
    }
}

