/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ClusteredCacheBuilder
extends CacheConfigurationBuilder {
    private final CacheMode mode;
    private volatile ClusteringConfiguration clustering;

    ClusteredCacheBuilder(String containerName, String cacheName, CacheMode mode) {
        super(containerName, cacheName);
        this.mode = mode;
    }

    @Override
    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        Mode mode = (Mode)ModelNodes.asEnum((ModelNode)ClusteredCacheResourceDefinition.Attribute.MODE.getDefinition().resolveModelAttribute(context, model), Mode.class);
        ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering().cacheMode(mode.apply(this.mode));
        if (mode.isSynchronous()) {
            builder.sync().replTimeout(ClusteredCacheResourceDefinition.Attribute.REMOTE_TIMEOUT.getDefinition().resolveModelAttribute(context, model).asLong());
        } else {
            builder.async();
        }
        this.clustering = builder.create();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        builder.clustering().read(this.clustering);
        super.accept(builder);
    }
}

