/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.security.smime.EnvelopedInput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class EnvelopedInputImpl
implements EnvelopedInput {
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private Class type;
    private Type genericType;
    private MimeBodyPart body;
    private Annotation[] annotations;
    private Providers providers;

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setType(GenericType type) {
        this.type = type.getRawType();
        this.genericType = type.getType();
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public MimeBodyPart getBody() {
        return this.body;
    }

    public void setBody(MimeBodyPart body) {
        this.body = body;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public Object getEntity() {
        return this.getEntity(this.type, this.genericType, this.annotations, this.privateKey, this.certificate);
    }

    public Object getEntity(PrivateKey pKey, X509Certificate cert) {
        return this.getEntity(this.type, this.genericType, this.annotations, pKey, cert);
    }

    public Object getEntity(Class type) {
        return this.getEntity(type, null, this.annotations, this.privateKey, this.certificate);
    }

    public Object getEntity(Class type, PrivateKey key, X509Certificate cert) {
        return this.getEntity(type, null, this.annotations, key, cert);
    }

    @Override
    public Object getEntity(GenericType type) {
        return this.getEntity(type.getRawType(), type.getType(), this.annotations, this.privateKey, this.certificate);
    }

    @Override
    public Object getEntity(GenericType type, PrivateKey key, X509Certificate cert) {
        return this.getEntity(type, this.annotations, key, cert);
    }

    public Object getEntity(GenericType gt, Annotation[] ann, PrivateKey pKey, X509Certificate cert) {
        return this.getEntity(gt.getRawType(), gt.getType(), ann, pKey, cert);
    }

    public Object getEntity(Class t, Type gt, Annotation[] ann, PrivateKey pKey, X509Certificate cert) {
        MimeBodyPart decrypted = null;
        try {
            MimeBodyPart encryptedBodyPart = this.body;
            SMIMEEnveloped m = new SMIMEEnveloped(encryptedBodyPart);
            JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
            RecipientInformationStore recipients = m.getRecipientInfos();
            RecipientInformation recipient = recipients.get((RecipientId)recId);
            JceKeyTransEnvelopedRecipient pKeyRecp = new JceKeyTransEnvelopedRecipient(pKey);
            decrypted = SMIMEUtil.toMimeBodyPart((byte[])recipient.getContent((Recipient)pKeyRecp));
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return EnvelopedInputImpl.extractEntity(t, gt, ann, decrypted, this.providers);
    }

    public static Object extractEntity(Class t, Type gt, Annotation[] ann, MimeBodyPart decrypted, Providers providers) {
        MediaType mediaType;
        MessageBodyReader reader;
        Headers mimeHeaders = new Headers();
        Enumeration e = null;
        try {
            e = decrypted.getAllHeaders();
        }
        catch (MessagingException e1) {
            throw new RuntimeException(e1);
        }
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            mimeHeaders.add((Object)header.getName(), (Object)header.getValue());
        }
        String contentType = "text/plain";
        if (mimeHeaders.containsKey((Object)"Content-Type")) {
            contentType = (String)mimeHeaders.getFirst((Object)"Content-Type");
        }
        if ((reader = providers.getMessageBodyReader(t, gt, ann, mediaType = MediaType.valueOf((String)contentType))) == null) {
            throw new RuntimeException(Messages.MESSAGES.couldNotFindMessageBodyReader(t.getClass().getName()));
        }
        Providers old = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)providers);
        try {
            InputStream inputStream = null;
            inputStream = EnvelopedInput.class.isAssignableFrom(t) ? decrypted.getRawInputStream() : decrypted.getInputStream();
            Object object = reader.readFrom(t, gt, ann, mediaType, (MultivaluedMap)mimeHeaders, inputStream);
            return object;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (old != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)old);
            }
        }
    }
}

