/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionSumScorer
extends DisjunctionScorer {
    private final float[] coord;

    DisjunctionSumScorer(Weight weight, List<Scorer> subScorers, float[] coord, boolean needsScores) {
        super(weight, subScorers, needsScores);
        this.coord = coord;
    }

    @Override
    protected float score(DisiWrapper<Scorer> topList) throws IOException {
        double score = 0.0;
        int freq = 0;
        DisiWrapper<Scorer> w = topList;
        while (w != null) {
            score += (double)((Scorer)w.iterator).score();
            ++freq;
            w = w.next;
        }
        return (float)score * this.coord[freq];
    }
}

