/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Set;

public class OIndexAbstractDelegate<T>
implements OIndex<T> {
    protected OIndex<T> delegate;

    public OIndexAbstractDelegate(OIndex<T> iDelegate) {
        this.delegate = iDelegate;
    }

    @Override
    public OIndexInternal<T> getInternal() {
        OIndex<T> internal;
        for (internal = this.delegate; !(internal instanceof OIndexInternal) && internal != null; internal = internal.getInternal()) {
        }
        return (OIndexInternal)internal;
    }

    @Override
    public OIndex<T> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return this.delegate.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener);
    }

    @Override
    public T get(Object iKey) {
        return this.delegate.get(iKey);
    }

    @Override
    public boolean contains(Object iKey) {
        return this.delegate.contains(iKey);
    }

    @Override
    public OIndex<T> put(Object iKey, OIdentifiable iValue) {
        this.checkForKeyType(iKey);
        return this.delegate.put(iKey, iValue);
    }

    @Override
    public long getRebuildVersion() {
        return this.delegate.getRebuildVersion();
    }

    @Override
    public boolean remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        return this.delegate.remove(iKey, iRID);
    }

    @Override
    public OIndex<T> clear() {
        return this.delegate.clear();
    }

    protected void checkForKeyType(Object iKey) {
        if (this.delegate.getDefinition() == null) {
            OType type = OType.getTypeByClass(iKey.getClass());
            if (type == null) {
                return;
            }
            OIndexManagerProxy indexManager = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getIndexManager();
            this.getInternal().setType(type);
            indexManager.save();
        }
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        return this.delegate.iterateEntriesMinor(toKey, toInclusive, ascOrder);
    }

    @Override
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    public long count(Object iKey) {
        return this.delegate.count(iKey);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public OIndex<T> delete() {
        return this.delegate.delete();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public String getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    @Override
    public boolean isAutomatic() {
        return this.delegate.isAutomatic();
    }

    @Override
    public boolean isUnique() {
        return this.delegate.isUnique();
    }

    @Override
    public ODocument getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public ODocument getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public long rebuild() {
        return this.delegate.rebuild();
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.delegate.rebuild(iProgressListener);
    }

    @Override
    public OType[] getKeyTypes() {
        return this.delegate.getKeyTypes();
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.delegate.getDefinition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexAbstractDelegate that = (OIndexAbstractDelegate)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        return this.delegate.iterateEntries(keys, ascSortOrder);
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        return this.delegate.checkEntry(iRecord, iKey);
    }

    @Override
    public Set<String> getClusters() {
        return this.delegate.getClusters();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public long getKeySize() {
        return this.delegate.getKeySize();
    }

    @Override
    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.delegate.supportsOrderedIterations();
    }

    @Override
    public boolean isRebuilding() {
        return this.delegate.isRebuilding();
    }

    @Override
    public Object getFirstKey() {
        return this.delegate.getFirstKey();
    }

    @Override
    public Object getLastKey() {
        return this.delegate.getLastKey();
    }

    @Override
    public int getIndexId() {
        return this.delegate.getIndexId();
    }

    @Override
    public OIndexCursor cursor() {
        return this.delegate.cursor();
    }

    @Override
    public OIndexCursor descCursor() {
        return this.delegate.descCursor();
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return this.delegate.keyCursor();
    }

    @Override
    public int compareTo(OIndex<T> o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public int getVersion() {
        return this.delegate.getVersion();
    }
}

