/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;

public class OUserTrigger
extends ODocumentHookAbstract {
    private OClass userClass;
    private OClass roleClass;

    public OUserTrigger(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        OImmutableClass clazz = null;
        if (iRecord instanceof ODocument) {
            clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)iRecord);
        }
        if (clazz == null || !clazz.isOuser() && !clazz.isOrole()) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        return super.onTrigger(iType, iRecord);
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        if (ODocumentInternal.getImmutableSchemaClass(iDocument).isOuser()) {
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if (ODocumentInternal.getImmutableSchemaClass(iDocument).isOuser()) {
            return this.encodePassword(iDocument);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    private ORecordHook.RESULT encodePassword(ODocument iDocument) {
        if (iDocument.field("name") == null) {
            throw new OSecurityException("User name not found");
        }
        String password = (String)iDocument.field("password");
        if (password == null) {
            throw new OSecurityException("User '" + iDocument.field("name") + "' has no password");
        }
        if (Orient.instance().getSecurity() != null) {
            Orient.instance().getSecurity().validatePassword(password);
        }
        if (!password.startsWith("{")) {
            iDocument.field("password", OUser.encryptPassword(password));
            return ORecordHook.RESULT.RECORD_CHANGED;
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }
}

