/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OSchedulerImpl
implements OScheduler {
    private ConcurrentHashMap<String, OScheduledEvent> events = new ConcurrentHashMap();

    @Override
    public void scheduleEvent(OScheduledEvent event) {
        if (event.getDocument().getIdentity().isNew()) {
            event.save();
        }
        if (this.events.putIfAbsent(event.getName(), event) == null) {
            event.schedule();
        }
    }

    @Override
    public void removeEvent(String eventName) {
        OScheduledEvent event = this.events.remove(eventName);
        if (event != null) {
            event.interrupt();
        }
    }

    @Override
    public Map<String, OScheduledEvent> getEvents() {
        return this.events;
    }

    @Override
    public OScheduledEvent getEvent(String name) {
        return this.events.get(name);
    }

    @Override
    public void load() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            ORecordIteratorClass<ODocument> result = db.browseClass("OSchedule");
            for (ODocument d : result) {
                OScheduledEvent event = new OScheduledEvent(d);
                if (this.events.putIfAbsent(event.getName(), event) != null) continue;
                this.scheduleEvent(event);
            }
        }
    }

    @Override
    public void close() {
        for (OScheduledEvent event : this.events.values()) {
            event.interrupt();
        }
        this.events.clear();
    }

    @Override
    public void create() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OSchedule")) {
            return;
        }
        OClass f = db.getMetadata().getSchema().createClass("OSchedule");
        f.createProperty("name", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("rule", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("arguments", OType.EMBEDDEDMAP, (OType)null, true);
        f.createProperty("status", OType.STRING, (OType)null, true);
        f.createProperty("function", OType.LINK, db.getMetadata().getSchema().getClass("OFunction"), true).setMandatory(true).setNotNull(true);
        f.createProperty("starttime", OType.DATETIME, (OType)null, true);
    }
}

