/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectMapInterface;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.entity.OEntityManagerInternal;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelperManager;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringBuilderSerializable;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerEmbedded;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ORecordSerializerCSVAbstract
extends ORecordSerializerStringAbstract {
    public static final char FIELD_VALUE_SEPARATOR = ':';
    private final boolean preferSBTreeRIDSet = OGlobalConfiguration.PREFER_SBTREE_SET.getValueAsBoolean();

    private static OIdentifiable linkToStream(StringBuilder buffer, ODocument iParentRecord, Object iLinked) {
        ORID rid;
        if (iLinked == null) {
            return null;
        }
        ORID resultRid = null;
        if (iLinked instanceof ORID) {
            rid = (ORID)iLinked;
            assert (rid.getIdentity().isValid() || ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy) : "Impossible to serialize invalid link " + rid.getIdentity();
            resultRid = rid;
        } else {
            String boundDocumentField;
            if (iLinked instanceof String) {
                iLinked = new ORecordId((String)iLinked);
            } else if (!(iLinked instanceof ORecord) && (boundDocumentField = OObjectSerializerHelperManager.getInstance().getDocumentBoundField(iLinked.getClass())) != null) {
                iLinked = OObjectSerializerHelperManager.getInstance().getFieldValue(iLinked, boundDocumentField);
            }
            if (!(iLinked instanceof OIdentifiable)) {
                throw new IllegalArgumentException("Invalid object received. Expected a OIdentifiable but received type=" + iLinked.getClass().getName() + " and value=" + iLinked);
            }
            Object iLinkedRecord = ((OIdentifiable)iLinked).getRecord();
            rid = iLinkedRecord.getIdentity();
            assert (rid.getIdentity().isValid() || ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy) : "Impossible to serialize invalid link " + rid.getIdentity();
            ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
            if (iParentRecord != null && !database.isRetainRecords()) {
                resultRid = iLinkedRecord.getIdentity();
            }
        }
        if (rid.isValid()) {
            rid.toString(buffer);
        }
        return resultRid;
    }

    public Object fieldFromStream(ORecord iSourceRecord, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, String iValue) {
        if (iValue == null) {
            return null;
        }
        switch (iType) {
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: {
                return this.embeddedCollectionFromStream((ODocument)iSourceRecord, iType, iLinkedClass, iLinkedType, iValue);
            }
            case LINKSET: 
            case LINKLIST: {
                String value;
                if (iValue.length() == 0) {
                    return null;
                }
                String string = value = iValue.startsWith("[") || iValue.startsWith("<") ? iValue.substring(1, iValue.length() - 1) : iValue;
                if (iType == OType.LINKLIST) {
                    return new ORecordLazyList((ODocument)iSourceRecord).setStreamedContent(new StringBuilder(value));
                }
                return this.unserializeSet((ODocument)iSourceRecord, value);
            }
            case LINKMAP: {
                if (iValue.length() == 0) {
                    return null;
                }
                String value = iValue.substring(1, iValue.length() - 1);
                ORecordLazyMap map = new ORecordLazyMap((ODocument)iSourceRecord, 100);
                if (value.length() == 0) {
                    return map;
                }
                List<String> items = OStringSerializerHelper.smartSplit(value, ',', true, false, new char[0]);
                for (String item : items) {
                    List<String> entry;
                    if (item == null || item.isEmpty() || (entry = OStringSerializerHelper.smartSplit(item, ':', new char[0])).isEmpty()) continue;
                    String mapValue = entry.get(1);
                    if (mapValue != null && !mapValue.isEmpty()) {
                        mapValue = mapValue.substring(1);
                    }
                    map.put(ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, OType.STRING, entry.get(0)), new ORecordId(mapValue));
                }
                return map;
            }
            case EMBEDDEDMAP: {
                return this.embeddedMapFromStream((ODocument)iSourceRecord, iLinkedType, iValue, iName);
            }
            case LINK: {
                if (iValue.length() > 1) {
                    int pos = iValue.indexOf("@");
                    if (pos > -1) {
                        ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getImmutableSchemaSnapshot().getClass(iValue.substring(1, pos));
                    } else {
                        pos = 0;
                    }
                    String linkAsString = iValue.substring(pos + 1);
                    try {
                        return new ORecordId(linkAsString);
                    }
                    catch (IllegalArgumentException e) {
                        OLogManager.instance().error((Object)this, "Error on unmarshalling field '%s' of record '%s': value '%s' is not a link", iName, iSourceRecord, linkAsString);
                        return new ORecordId();
                    }
                }
                return null;
            }
            case EMBEDDED: {
                if (iValue.length() > 2) {
                    String value = iValue.substring(1, iValue.length() - 1);
                    Object embeddedObject = OStringSerializerEmbedded.INSTANCE.fromStream(value);
                    if (embeddedObject instanceof ODocument) {
                        ODocumentInternal.addOwner((ODocument)embeddedObject, iSourceRecord);
                    }
                    return embeddedObject;
                }
                return null;
            }
            case LINKBAG: {
                String value = iValue.charAt(0) == '%' ? iValue.substring(1, iValue.length() - 1) : iValue;
                return ORidBag.fromStream(value);
            }
        }
        return ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, iType, iValue);
    }

    public Map<String, Object> embeddedMapFromStream(ODocument iSourceDocument, OType iLinkedType, String iValue, String iName) {
        if (iValue.length() == 0) {
            return null;
        }
        String value = iValue.substring(1, iValue.length() - 1);
        OTrackedMap map = iLinkedType == OType.LINK || iLinkedType == OType.EMBEDDED ? new ORecordLazyMap(iSourceDocument, 100) : new OTrackedMap(iSourceDocument);
        if (value.length() == 0) {
            return map;
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', true, false, new char[0]);
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        for (String item : items) {
            Object mapValueObject;
            List<String> entries;
            if (item == null || item.isEmpty() || (entries = OStringSerializerHelper.smartSplit(item, ':', true, false, new char[0])).isEmpty()) continue;
            if (entries.size() > 1) {
                OType linkedType;
                String mapValue = entries.get(1);
                if (iLinkedType == null) {
                    if (!mapValue.isEmpty()) {
                        linkedType = ORecordSerializerCSVAbstract.getType(mapValue);
                        if ((iName == null || iSourceDocument.fieldType(iName) == null || iSourceDocument.fieldType(iName) != OType.EMBEDDEDMAP) && this.isConvertToLinkedMap(map, linkedType)) {
                            map = new ORecordLazyMap(iSourceDocument, 100);
                            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
                        } else if (map instanceof ORecordLazyMap && linkedType != OType.LINK) {
                            map = new OTrackedMap(iSourceDocument, map, null);
                        }
                    } else {
                        linkedType = OType.EMBEDDED;
                    }
                } else {
                    linkedType = iLinkedType;
                }
                if (linkedType == OType.EMBEDDED && mapValue.length() >= 2) {
                    mapValue = mapValue.substring(1, mapValue.length() - 1);
                }
                if ((mapValueObject = ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, linkedType, mapValue)) != null && mapValueObject instanceof ODocument) {
                    ODocumentInternal.addOwner((ODocument)mapValueObject, iSourceDocument);
                }
            } else {
                mapValueObject = null;
            }
            Object key = ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, OType.STRING, entries.get(0));
            try {
                map.put(key, mapValueObject);
            }
            catch (ClassCastException e) {
                throw OException.wrapException(new OSerializationException("Cannot load map because the type was not the expected: key=" + key + "(type " + key.getClass().toString() + "), value=" + mapValueObject + "(type " + key.getClass() + ")"), e);
            }
        }
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldToStream(ODocument iRecord, StringBuilder iOutput, OUserObject2RecordHandler iObjHandler, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, Object iValue, boolean iSaveOnlyDirty) {
        if (iValue == null) {
            return;
        }
        long timer = PROFILER.startChrono();
        switch (iType) {
            case LINK: {
                if (!(iValue instanceof OIdentifiable)) {
                    throw new OSerializationException("Found an unexpected type during marshalling of a LINK where a OIdentifiable (ORID or any Record) was expected. The string representation of the object is: " + iValue);
                }
                if (!((OIdentifiable)iValue).getIdentity().isValid() && iValue instanceof ODocument && ((ODocument)iValue).isEmbedded()) {
                    this.fieldToStream(iRecord, iOutput, iObjHandler, OType.EMBEDDED, iLinkedClass, iLinkedType, iName, iValue, iSaveOnlyDirty);
                    break;
                }
                OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, iValue);
                if (link != null) {
                    iRecord.field(iName, link);
                }
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.link2string"), "Serialize link to string", timer);
                break;
            }
            case LINKLIST: {
                iOutput.append('[');
                if (iValue instanceof ORecordLazyList && ((ORecordLazyList)iValue).getStreamedContent() != null) {
                    iOutput.append((CharSequence)((ORecordLazyList)iValue).getStreamedContent());
                    PROFILER.updateCounter(PROFILER.getProcessMetric("serializer.record.string.linkList2string.cached"), "Serialize linklist to string in stream mode", 1L);
                } else {
                    ORecordLazyList coll;
                    Iterator<Object> it;
                    if (iValue instanceof OMultiCollectionIterator) {
                        OMultiCollectionIterator iterator = (OMultiCollectionIterator)iValue;
                        iterator.reset();
                        it = iterator;
                        coll = null;
                    } else if (!(iValue instanceof ORecordLazyList)) {
                        coll = new ORecordLazyList(iRecord);
                        if (iValue.getClass().isArray()) {
                            Iterable<Object> iterab = OMultiValue.getMultiValueIterable(iValue, false);
                            for (Object i : iterab) {
                                coll.add((OIdentifiable)i);
                            }
                        } else {
                            coll.addAll((Collection)iValue);
                            ((Collection)iValue).clear();
                        }
                        iRecord.field(iName, coll);
                        it = coll.rawIterator();
                    } else {
                        coll = (ORecordLazyList)iValue;
                        if (coll.getStreamedContent() != null) {
                            iOutput.append((CharSequence)coll.getStreamedContent());
                            PROFILER.updateCounter(PROFILER.getProcessMetric("serializer.record.string.linkList2string.cached"), "Serialize linklist to string in stream mode", 1L);
                            it = coll.newItemsIterator();
                        } else {
                            it = coll.rawIterator();
                        }
                    }
                    if (it != null && it.hasNext()) {
                        StringBuilder buffer = new StringBuilder(128);
                        int items = 0;
                        while (it.hasNext()) {
                            OIdentifiable item;
                            OIdentifiable newRid;
                            if (items > 0) {
                                buffer.append(',');
                            }
                            if ((newRid = ORecordSerializerCSVAbstract.linkToStream(buffer, iRecord, item = (OIdentifiable)it.next())) != null) {
                                ((OLazyIterator)it).update(newRid);
                            }
                            ++items;
                        }
                        if (coll != null) {
                            coll.convertRecords2Links();
                        }
                        iOutput.append((CharSequence)buffer);
                        if (coll != null) {
                            coll.setStreamedContent(buffer);
                        }
                    }
                }
                iOutput.append(']');
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.linkList2string"), "Serialize linklist to string", timer);
                break;
            }
            case LINKSET: {
                if (!(iValue instanceof OStringBuilderSerializable)) {
                    Collection coll;
                    if (iValue instanceof OAutoConvertToRecord) {
                        ((OAutoConvertToRecord)iValue).setAutoConvertToRecord(false);
                    }
                    if (!(iValue instanceof ORecordLazySet)) {
                        ORecordLazySet set = new ORecordLazySet(iRecord);
                        set.addAll((Collection)iValue);
                        iRecord.field(iName, set);
                        coll = set;
                    } else {
                        coll = (Collection)iValue;
                    }
                    this.serializeSet(coll, iOutput);
                } else {
                    OStringBuilderSerializable coll = (OStringBuilderSerializable)iValue;
                    coll.toStream(iOutput);
                }
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.linkSet2string"), "Serialize linkset to string", timer);
                break;
            }
            case LINKMAP: {
                iOutput.append('{');
                Map map = (Map)iValue;
                if (map instanceof OLazyObjectMapInterface) {
                    ((OLazyObjectMapInterface)map).setConvertToRecord(false);
                }
                boolean invalidMap = false;
                try {
                    int items = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (items++ > 0) {
                            iOutput.append(',');
                        }
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.STRING, entry.getKey());
                        iOutput.append(':');
                        OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, entry.getValue());
                        if (link == null || invalidMap) continue;
                        invalidMap = true;
                    }
                }
                finally {
                    if (map instanceof OLazyObjectMapInterface) {
                        ((OLazyObjectMapInterface)map).setConvertToRecord(true);
                    }
                }
                if (invalidMap) {
                    ORecordLazyMap newMap = new ORecordLazyMap(iRecord, 100);
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(entry.getKey(), (OIdentifiable)entry.getValue());
                    }
                    map.clear();
                    iRecord.field(iName, newMap);
                }
                iOutput.append('}');
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.linkMap2string"), "Serialize linkmap to string", timer);
                break;
            }
            case EMBEDDED: {
                if (iValue instanceof ORecord) {
                    iOutput.append('(');
                    this.toString((ORecord)iValue, iOutput, null, iObjHandler, false, true);
                    iOutput.append(')');
                } else if (iValue instanceof ODocumentSerializable) {
                    ODocument doc = ((ODocumentSerializable)iValue).toDocument();
                    doc.field("__orientdb_serilized_class__ ", iValue.getClass().getName());
                    iOutput.append('(');
                    this.toString(doc, iOutput, null, iObjHandler, false, true);
                    iOutput.append(')');
                } else if (iValue != null) {
                    iOutput.append(iValue.toString());
                }
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embed2string"), "Serialize embedded to string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                this.embeddedCollectionToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iSaveOnlyDirty, false);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedList2string"), "Serialize embeddedlist to string", timer);
                break;
            }
            case EMBEDDEDSET: {
                this.embeddedCollectionToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iSaveOnlyDirty, true);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedSet2string"), "Serialize embeddedset to string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                this.embeddedMapToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iSaveOnlyDirty);
                PROFILER.stopChrono(PROFILER.getProcessMetric("serializer.record.string.embedMap2string"), "Serialize embeddedmap to string", timer);
                break;
            }
            case LINKBAG: {
                iOutput.append('%');
                ((ORidBag)iValue).toStream(iOutput);
                iOutput.append(';');
                break;
            }
            default: {
                ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iType, iValue);
            }
        }
    }

    public void embeddedMapToStream(ODatabase<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, final OClass iLinkedClass, OType iLinkedType, Object iValue, boolean iSaveOnlyDirty) {
        iOutput.append('{');
        if (iValue != null) {
            int items = 0;
            for (Map.Entry o : ((Map)iValue).entrySet()) {
                if (items > 0) {
                    iOutput.append(',');
                }
                if (o != null) {
                    ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.STRING, o.getKey());
                    iOutput.append(':');
                    if (o.getValue() instanceof ODocument && ((ODocument)o.getValue()).getIdentity().isValid()) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.LINK, o.getValue());
                    } else if (o.getValue() instanceof ORecord || o.getValue() instanceof ODocumentSerializable) {
                        ODocument record;
                        if (o.getValue() instanceof ODocument) {
                            record = (ODocument)o.getValue();
                        } else if (o.getValue() instanceof ODocumentSerializable) {
                            record = ((ODocumentSerializable)o.getValue()).toDocument();
                            record.field("__orientdb_serilized_class__ ", o.getValue().getClass().getName());
                        } else {
                            if (iDatabase == null && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
                                iDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
                            }
                            record = OObjectSerializerHelperManager.getInstance().toStream(o.getValue(), new ODocument(o.getValue().getClass().getSimpleName()), iDatabase instanceof ODatabaseObject ? ((ODatabaseObject)((Object)iDatabase)).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                                @Override
                                public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
                                    return iRecord;
                                }

                                @Override
                                public ORecord getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                                    return new ODocument(iLinkedClass);
                                }

                                @Override
                                public boolean existsUserObjectByRID(ORID iRID) {
                                    return false;
                                }

                                @Override
                                public void registerUserObject(Object iObject, ORecord iRecord) {
                                }

                                @Override
                                public void registerUserObjectAfterLinkSave(ORecord iRecord) {
                                }
                            }, null, iSaveOnlyDirty);
                        }
                        iOutput.append('(');
                        this.toString(record, iOutput, null, iObjHandler, false, true);
                        iOutput.append(')');
                    } else if (o.getValue() instanceof Set) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDSET, o.getValue());
                    } else if (o.getValue() instanceof Collection) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDLIST, o.getValue());
                    } else if (o.getValue() instanceof Map) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDMAP, o.getValue());
                    } else if (iLinkedType == null && o.getValue() != null) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.getTypeByClass(o.getValue().getClass()), o.getValue());
                    } else {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iLinkedType, o.getValue());
                    }
                }
                ++items;
            }
        }
        iOutput.append('}');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object embeddedCollectionFromStream(ODocument iDocument, OType iType, OClass iLinkedClass, OType iLinkedType, String iValue) {
        ORecordLazyList coll;
        String value;
        if (iValue.length() == 0) {
            return null;
        }
        String string = value = iValue.charAt(0) == '[' || iValue.charAt(0) == '<' ? iValue.substring(1, iValue.length() - 1) : iValue;
        if (iLinkedType == OType.LINK) {
            if (iDocument != null) {
                coll = iType == OType.EMBEDDEDLIST ? new ORecordLazyList(iDocument).setStreamedContent(new StringBuilder(value)) : this.unserializeSet(iDocument, value);
            } else {
                if (iType != OType.EMBEDDEDLIST) return this.unserializeSet(iDocument, value);
                coll = new ORecordLazyList().setStreamedContent(new StringBuilder(value));
            }
        } else {
            ORecordLazyList oRecordLazyList = coll = iType == OType.EMBEDDEDLIST ? new OTrackedList(iDocument) : new OTrackedSet(iDocument);
        }
        if (value.length() == 0) {
            return coll;
        }
        if (coll instanceof ORecordElement) {
            ((ORecordElement)coll).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', true, false, new char[0]);
        for (String item : items) {
            Object objectToAdd = null;
            OType linkedType = null;
            if (item.equals("null")) {
                objectToAdd = null;
            } else if (item.length() > 2 && item.charAt(0) == '(') {
                if (!(item = item.substring(1, item.length() - 1)).isEmpty()) {
                    objectToAdd = (iLinkedClass = OStringSerializerHelper.getRecordClassName(item, iLinkedClass)) != null ? this.fromString(item, new ODocument(iLinkedClass.getName()), null) : ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, OType.EMBEDDED, item);
                }
            } else {
                int begin;
                if (linkedType == null && (linkedType = (begin = item.length() > 0 ? (int)item.charAt(0) : 35) == 35 ? OType.LINK : ORecordSerializerCSVAbstract.getType(item)) == null) {
                    throw new IllegalArgumentException("Linked type cannot be null. Probably the serialized type has not stored the type along with data");
                }
                if (iLinkedType == OType.CUSTOM) {
                    item = item.substring(1, item.length() - 1);
                }
                objectToAdd = ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, linkedType, item);
            }
            if (objectToAdd != null && objectToAdd instanceof ODocument && coll instanceof ORecordElement) {
                ODocumentInternal.addOwner((ODocument)objectToAdd, coll);
            }
            coll.add(objectToAdd);
        }
        if (!(coll instanceof ORecordElement)) return coll;
        ((ORecordElement)coll).setInternalStatus(ORecordElement.STATUS.LOADED);
        return coll;
    }

    public StringBuilder embeddedCollectionToStream(ODatabase<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, OClass iLinkedClass, OType iLinkedType, Object iValue, boolean iSaveOnlyDirty, boolean iSet) {
        iOutput.append(iSet ? (char)'<' : '[');
        Iterator<Object> iterator = OMultiValue.getMultiValueIterator(iValue, false);
        OType linkedType = iLinkedType;
        int i = 0;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (i > 0) {
                iOutput.append(',');
            }
            if (o == null) {
                iOutput.append("null");
            } else {
                OClass linkedClass;
                OIdentifiable id = null;
                ODocument doc = null;
                if (!(o instanceof OIdentifiable)) {
                    String fieldBound = OObjectSerializerHelperManager.getInstance().getDocumentBoundField(o.getClass());
                    if (fieldBound != null) {
                        OObjectSerializerHelperManager.getInstance().invokeCallback(o, null, OBeforeSerialization.class);
                        doc = (ODocument)OObjectSerializerHelperManager.getInstance().getFieldValue(o, fieldBound);
                        OObjectSerializerHelperManager.getInstance().invokeCallback(o, doc, OAfterSerialization.class);
                        id = doc;
                    } else if (iLinkedType == null) {
                        linkedType = OType.getTypeByClass(o.getClass());
                    }
                    linkedClass = iLinkedClass;
                } else {
                    id = (OIdentifiable)o;
                    if (iLinkedType == null) {
                        linkedType = id.getIdentity().isValid() ? OType.LINK : OType.EMBEDDED;
                    }
                    if (id instanceof ODocument) {
                        doc = (ODocument)id;
                        if (doc.hasOwners()) {
                            linkedType = OType.EMBEDDED;
                        }
                        assert (linkedType == OType.EMBEDDED || id.getIdentity().isValid() || ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy) : "Impossible to serialize invalid link " + id.getIdentity();
                        linkedClass = ODocumentInternal.getImmutableSchemaClass(doc);
                    } else {
                        linkedClass = null;
                    }
                }
                if (id != null && linkedType != OType.LINK) {
                    iOutput.append('(');
                }
                if (linkedType == OType.EMBEDDED && o instanceof OIdentifiable) {
                    this.toString((ORecord)((OIdentifiable)o).getRecord(), iOutput, null);
                } else if (linkedType != OType.LINK && (linkedClass != null || doc != null)) {
                    if (id == null) {
                        if (iDatabase == null && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
                            iDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
                        }
                        id = OObjectSerializerHelperManager.getInstance().toStream(o, new ODocument(o.getClass().getSimpleName()), iDatabase instanceof ODatabaseObject ? ((ODatabaseObject)((Object)iDatabase)).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                            @Override
                            public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
                                return iRecord;
                            }

                            @Override
                            public ORecord getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                                return new ODocument(linkedClass);
                            }

                            @Override
                            public boolean existsUserObjectByRID(ORID iRID) {
                                return false;
                            }

                            @Override
                            public void registerUserObject(Object iObject, ORecord iRecord) {
                            }

                            @Override
                            public void registerUserObjectAfterLinkSave(ORecord iRecord) {
                            }
                        }, null, iSaveOnlyDirty);
                    }
                    this.toString(doc, iOutput, null, iObjHandler, false, true);
                } else {
                    if (iLinkedType == null) {
                        if (o != null) {
                            linkedType = OType.getTypeByClass(o.getClass());
                        }
                    } else if (iLinkedType == OType.CUSTOM) {
                        iOutput.append('^');
                    }
                    ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, linkedType, o);
                }
                if (id != null && linkedType != OType.LINK) {
                    iOutput.append(')');
                }
            }
            ++i;
        }
        iOutput.append(iSet ? (char)'>' : ']');
        return iOutput;
    }

    protected boolean isConvertToLinkedMap(Map<?, ?> map, OType linkedType) {
        boolean convert;
        boolean bl = convert = linkedType == OType.LINK && !(map instanceof ORecordLazyMap);
        if (convert) {
            for (Object value : map.values()) {
                if (value instanceof OIdentifiable) continue;
                return false;
            }
        }
        return convert;
    }

    private void serializeSet(Collection<OIdentifiable> coll, StringBuilder iOutput) {
        iOutput.append('<');
        int i = 0;
        for (OIdentifiable rid : coll) {
            if (i++ > 0) {
                iOutput.append(',');
            }
            iOutput.append(rid.getIdentity().toString());
        }
        iOutput.append('>');
    }

    private ORecordLazySet unserializeSet(ODocument iSourceRecord, String value) {
        ORecordLazySet coll = new ORecordLazySet(iSourceRecord);
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
        for (String item : items) {
            if (item.length() == 0) {
                coll.add(new ORecordId());
                continue;
            }
            if (item.startsWith("#")) {
                coll.add(new ORecordId(item));
                continue;
            }
            ORecord doc = this.fromString(item);
            if (doc instanceof ODocument) {
                ODocumentInternal.addOwner((ODocument)doc, iSourceRecord);
            }
            coll.add(doc);
        }
        return coll;
    }
}

