/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.method.OSQLMethodRuntime;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ORuntimeResult {
    private final Object fieldValue;
    private final Map<String, Object> projections;
    private final ODocument value;
    private OCommandContext context;

    public ORuntimeResult(Object iFieldValue, Map<String, Object> iProjections, int iProgressive, OCommandContext iContext) {
        this.fieldValue = iFieldValue;
        this.projections = iProjections;
        this.context = iContext;
        this.value = ORuntimeResult.createProjectionDocument(iProgressive);
    }

    public static ODocument createProjectionDocument(int iProgressive) {
        ODocument doc = new ODocument().setOrdered(true).setTrackingChanges(false);
        ((ORecordId)doc.getIdentity()).clusterId = -2;
        ((ORecordId)doc.getIdentity()).clusterPosition = iProgressive;
        return doc;
    }

    public static ODocument applyRecord(ODocument iValue, Map<String, Object> iProjections, OCommandContext iContext, OIdentifiable iRecord) {
        ORecord record;
        ORecord oRecord = record = iRecord != null ? (ORecord)iRecord.getRecord() : null;
        if (98 == ORecordInternal.getRecordType(record)) {
            for (Map.Entry<String, Object> projection : iProjections.entrySet()) {
                if ("@rid".equalsIgnoreCase("" + projection.getValue())) {
                    iValue.field(projection.getKey(), record.getIdentity());
                    continue;
                }
                if ("@size".equalsIgnoreCase("" + projection.getValue())) {
                    iValue.field(projection.getKey(), record.getSize());
                    continue;
                }
                if ("@version".equalsIgnoreCase("" + projection.getValue())) {
                    iValue.field(projection.getKey(), record.getVersion());
                    continue;
                }
                Object val = projection.getValue();
                if (val instanceof Number || val instanceof String || val instanceof Boolean) {
                    iValue.field(projection.getKey(), val);
                    continue;
                }
                iValue.field(projection.getKey(), (Object)null);
            }
            return iValue;
        }
        ODocument inputDocument = (ODocument)record;
        if (iProjections.isEmpty()) {
            inputDocument.copyTo(iValue);
        } else {
            for (Map.Entry<String, Object> projection : iProjections.entrySet()) {
                OType type;
                Object projectionValue;
                String prjName = projection.getKey();
                Object v = projection.getValue();
                if (v == null && prjName != null) {
                    iValue.field(prjName, (Object)null);
                    continue;
                }
                if (v != null && v.equals("*")) {
                    inputDocument.copyTo(iValue);
                    continue;
                }
                if (v instanceof OSQLFilterItemVariable || v instanceof OSQLFilterItemField) {
                    OSQLFilterItemAbstract var = (OSQLFilterItemAbstract)v;
                    OPair<OSQLMethodRuntime, Object[]> last = var.getLastChainOperator();
                    if (last != null && ((OSQLMethodRuntime)last.getKey()).getMethod() instanceof OSQLMethodField && last.getValue() != null && last.getValue().length == 1 && last.getValue()[0].equals("*")) {
                        Object value = ((OSQLFilterItemAbstract)v).getValue(inputDocument, iValue, iContext);
                        if (inputDocument != null && value != null && inputDocument instanceof ODocument && value instanceof ODocument) {
                            for (String fieldName : ((ODocument)value).fieldNames()) {
                                iValue.field(prjName + fieldName, ((ODocument)value).field(fieldName));
                            }
                        }
                        projectionValue = null;
                    } else {
                        projectionValue = ((OSQLFilterItemAbstract)v).getValue(inputDocument, iValue, iContext);
                    }
                } else if (v instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)v;
                    projectionValue = f.execute(inputDocument, inputDocument, iValue, iContext);
                } else {
                    if (v == null) {
                        iValue.field(prjName, v);
                        continue;
                    }
                    projectionValue = v;
                }
                if (projectionValue == null) continue;
                if (projectionValue instanceof ORidBag) {
                    iValue.field(prjName, new ORidBag((ORidBag)projectionValue));
                    continue;
                }
                if (projectionValue instanceof OIdentifiable && !(projectionValue instanceof ORID) && !(projectionValue instanceof ORecord)) {
                    iValue.field(prjName, ((OIdentifiable)projectionValue).getRecord());
                    continue;
                }
                if (projectionValue instanceof Iterator) {
                    boolean link = true;
                    if (projectionValue instanceof OResettable) {
                        ((OResettable)projectionValue).reset();
                    }
                    ArrayList iteratorValues = new ArrayList();
                    Iterator projectionValueIterator = (Iterator)projectionValue;
                    while (projectionValueIterator.hasNext()) {
                        Object value = projectionValueIterator.next();
                        if (value instanceof OIdentifiable && (value = ((OIdentifiable)value).getRecord()) != null && !((OIdentifiable)value).getIdentity().isPersistent()) {
                            link = false;
                        }
                        if (value == null) continue;
                        iteratorValues.add(value);
                    }
                    iValue.field(prjName, iteratorValues, link ? OType.LINKLIST : OType.EMBEDDEDLIST);
                    continue;
                }
                if (projectionValue instanceof ODocument && !((ODocument)projectionValue).getIdentity().isPersistent()) {
                    iValue.field(prjName, projectionValue, OType.EMBEDDED);
                    continue;
                }
                if (projectionValue instanceof Set) {
                    type = OType.getTypeByValue(projectionValue);
                    if (type == OType.LINKSET && !ORuntimeResult.entriesPersistent((Collection)projectionValue)) {
                        type = OType.EMBEDDEDSET;
                    }
                    iValue.field(prjName, projectionValue, type);
                    continue;
                }
                if (projectionValue instanceof Map) {
                    type = OType.getTypeByValue(projectionValue);
                    if (type == OType.LINKMAP && !ORuntimeResult.entriesPersistent(((Map)projectionValue).values())) {
                        type = OType.EMBEDDEDMAP;
                    }
                    iValue.field(prjName, projectionValue, type);
                    continue;
                }
                if (projectionValue instanceof List) {
                    type = OType.getTypeByValue(projectionValue);
                    if (type == OType.LINKLIST && !ORuntimeResult.entriesPersistent((Collection)projectionValue)) {
                        type = OType.EMBEDDEDLIST;
                    }
                    iValue.field(prjName, projectionValue, type);
                    continue;
                }
                iValue.field(prjName, projectionValue);
            }
        }
        return iValue;
    }

    private static boolean entriesPersistent(Collection<OIdentifiable> projectionValue) {
        if (projectionValue instanceof ORecordLazyMultiValue) {
            Iterator<OIdentifiable> it = ((ORecordLazyMultiValue)((Object)projectionValue)).rawIterator();
            while (it.hasNext()) {
                OIdentifiable rec = it.next();
                if (rec == null || rec.getIdentity().isPersistent()) continue;
                return false;
            }
        } else {
            for (OIdentifiable rec : projectionValue) {
                if (rec == null || rec.getIdentity().isPersistent()) continue;
                return false;
            }
        }
        return true;
    }

    public static ODocument getResult(ODocument iValue, Map<String, Object> iProjections) {
        if (iValue != null) {
            boolean canExcludeResult = false;
            for (Map.Entry<String, Object> projection : iProjections.entrySet()) {
                Object v;
                if (iValue.containsField(projection.getKey()) || !((v = projection.getValue()) instanceof OSQLFunctionRuntime)) continue;
                OSQLFunctionRuntime f = (OSQLFunctionRuntime)v;
                canExcludeResult = f.filterResult();
                Object fieldValue = f.getResult();
                if (fieldValue == null) continue;
                iValue.field(projection.getKey(), fieldValue);
            }
            if (canExcludeResult && iValue.isEmpty()) {
                return null;
            }
            ORecordInternal.unsetDirty(iValue);
        }
        return iValue;
    }

    public static ODocument getProjectionResult(int iId, Map<String, Object> iProjections, OCommandContext iContext, OIdentifiable iRecord) {
        return ORuntimeResult.getResult(ORuntimeResult.applyRecord(ORuntimeResult.createProjectionDocument(iId), iProjections, iContext, iRecord), iProjections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument applyRecord(OIdentifiable iRecord) {
        ORuntimeResult oRuntimeResult = this;
        synchronized (oRuntimeResult) {
            return ORuntimeResult.applyRecord(this.value, this.projections, this.context, iRecord);
        }
    }

    public void applyValue(String iName, Object iValue) {
        this.value.field(iName, iValue);
    }

    public ODocument getResult() {
        return ORuntimeResult.getResult(this.value, this.projections);
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }
}

