/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.IOException;

public class OClusterPositionMapBucket
extends ODurablePage {
    private static final int NEXT_PAGE_OFFSET = 28;
    private static final int SIZE_OFFSET = 36;
    private static final int POSITIONS_OFFSET = 40;
    public static final byte NOT_EXISTENT = 0;
    public static final byte REMOVED = 1;
    public static final byte FILLED = 2;
    public static final byte ALLOCATED = 4;
    public static final int ENTRY_SIZE = 13;
    public static final int MAX_ENTRIES = (MAX_PAGE_SIZE_BYTES - 40) / 13;

    public OClusterPositionMapBucket(OCacheEntry cacheEntry, OWALChanges changes) {
        super(cacheEntry, changes);
    }

    public int add(long pageIndex, int recordPosition) throws IOException {
        int size = this.getIntValue(36);
        int position = this.entryPosition(size);
        position += this.setByteValue(position, (byte)2);
        position += this.setLongValue(position, pageIndex);
        this.setIntValue(position, recordPosition);
        this.setIntValue(36, size + 1);
        return size;
    }

    public int allocate() throws IOException {
        int size = this.getIntValue(36);
        int position = this.entryPosition(size);
        position += this.setByteValue(position, (byte)4);
        position += this.setLongValue(position, -1L);
        this.setIntValue(position, -1);
        this.setIntValue(36, size + 1);
        return size;
    }

    public PositionEntry get(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return null;
        }
        int position = this.entryPosition(index);
        if (this.getByteValue(position) != 2) {
            return null;
        }
        return this.readEntry(position);
    }

    public void set(int index, PositionEntry entry) throws IOException {
        int size = this.getIntValue(36);
        if (index >= size) {
            throw new OStorageException("Provided index " + index + " is out of range");
        }
        int position = this.entryPosition(index);
        byte flag = this.getByteValue(position);
        if (flag == 4) {
            this.setByteValue(position, (byte)2);
        } else if (flag != 2) {
            throw new OStorageException("Provided index " + index + " points to removed entry");
        }
        this.updateEntry(position, entry);
    }

    public void resurrect(int index, PositionEntry entry) throws IOException {
        int size = this.getIntValue(36);
        if (index >= size) {
            throw new OStorageException("Cannot resurrect a record: provided index " + index + " is out of range");
        }
        int position = this.entryPosition(index);
        byte flag = this.getByteValue(position);
        if (flag != 1) {
            throw new OStorageException("Cannot resurrect a record: provided index " + index + " points to a non removed entry");
        }
        this.setByteValue(position, (byte)2);
        this.updateEntry(position, entry);
    }

    private int entryPosition(int index) {
        return index * 13 + 40;
    }

    public boolean isFull() {
        return this.getIntValue(36) == MAX_ENTRIES;
    }

    public int getSize() {
        return this.getIntValue(36);
    }

    public PositionEntry remove(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return null;
        }
        int position = this.entryPosition(index);
        if (this.getByteValue(position) != 2) {
            return null;
        }
        this.setByteValue(position, (byte)1);
        return this.readEntry(position);
    }

    private PositionEntry readEntry(int position) {
        long pageIndex = this.getLongValue(++position);
        int pagePosition = this.getIntValue(position += 8);
        return new PositionEntry(pageIndex, pagePosition);
    }

    private void updateEntry(int position, PositionEntry entry) throws IOException {
        this.setLongValue(++position, entry.pageIndex);
        this.setIntValue(position += 8, entry.recordPosition);
    }

    public boolean exists(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return false;
        }
        int position = this.entryPosition(index);
        return this.getByteValue(position) == 2;
    }

    public byte getStatus(int index) {
        int size = this.getIntValue(36);
        if (index >= size) {
            return 0;
        }
        int position = this.entryPosition(index);
        return this.getByteValue(position);
    }

    public static class PositionEntry {
        private final long pageIndex;
        private final int recordPosition;

        public PositionEntry(long pageIndex, int recordPosition) {
            this.pageIndex = pageIndex;
            this.recordPosition = recordPosition;
        }

        public long getPageIndex() {
            return this.pageIndex;
        }

        public int getRecordPosition() {
            return this.recordPosition;
        }
    }
}

