/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.JsonUtilities;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.ODataPayload;
import com.microsoft.azure.storage.table.PropertyPair;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TablePayloadFormat;
import com.microsoft.azure.storage.table.TableRequestOptions;
import com.microsoft.azure.storage.table.TableResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

final class TableDeserializer {
    private static JsonFactory jsonFactory = new JsonFactory();

    TableDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TableEntity, R> ODataPayload<?> parseQueryResponse(InputStream inStream, TableRequestOptions options, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws JsonParseException, IOException, InstantiationException, IllegalAccessException, StorageException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        JsonParser parser = TableDeserializer.createJsonParserFromStream(inStream);
        try {
            if (resolver != null) {
                commonPayload = resolvedPayload = new ODataPayload();
            } else {
                corePayload = new ODataPayload();
                commonPayload = corePayload;
            }
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            HashMap<String, PropertyPair> classProperties = null;
            if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && clazzType != null) {
                classProperties = PropertyPair.generatePropertyPairs(clazzType);
            }
            while (parser.getCurrentToken() != null) {
                if (parser.getCurrentToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("value")) {
                    parser.nextToken();
                    JsonUtilities.assertIsStartArrayJsonToken(parser);
                    parser.nextToken();
                    while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                        TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, classProperties, resolver, options, opContext);
                        if (corePayload != null) {
                            corePayload.tableResults.add(res);
                        }
                        if (resolver != null) {
                            resolvedPayload.results.add(res.getResult());
                        } else {
                            corePayload.results.add((TableEntity)res.getResult());
                        }
                        parser.nextToken();
                    }
                    JsonUtilities.assertIsEndArrayJsonToken(parser);
                }
                parser.nextToken();
            }
        }
        finally {
            parser.close();
        }
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TableEntity, R> TableResult parseSingleOpResponse(InputStream inStream, TableRequestOptions options, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws JsonParseException, IOException, InstantiationException, IllegalAccessException, StorageException {
        JsonParser parser = TableDeserializer.createJsonParserFromStream(inStream);
        try {
            TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, null, resolver, options, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            parser.close();
        }
    }

    private static <T extends TableEntity, R> TableResult parseJsonEntity(JsonParser parser, Class<T> clazzType, HashMap<String, PropertyPair> classProperties, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws JsonParseException, IOException, StorageException, InstantiationException, IllegalAccessException {
        TableResult res = new TableResult();
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        JsonUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        while (parser.getCurrentName().startsWith("odata.")) {
            String name = parser.getCurrentName().substring("odata.".length());
            parser.nextToken();
            if (name.equals("etag")) {
                String etag = parser.getValueAsString();
                res.setEtag(etag);
            }
            parser.nextToken();
        }
        if (resolver == null && clazzType == null) {
            return res;
        }
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String key = "";
            String val = "";
            EdmType edmType = null;
            if (options.getTablePayloadFormat() != TablePayloadFormat.JsonNoMetadata && parser.getCurrentName().endsWith("@odata.type")) {
                parser.nextToken();
                edmType = EdmType.parse(parser.getValueAsString());
                parser.nextValue();
                key = parser.getCurrentName();
                val = parser.getValueAsString();
            } else {
                key = parser.getCurrentName();
                parser.nextToken();
                val = parser.getValueAsString();
                edmType = TableDeserializer.evaluateEdmType(parser.getCurrentToken(), parser.getValueAsString());
            }
            EntityProperty newProp = new EntityProperty(val, edmType);
            newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
            properties.put(key, newProp);
            parser.nextToken();
        }
        String partitionKey = null;
        String rowKey = null;
        Date timestamp = null;
        String etag = null;
        EntityProperty tempProp = (EntityProperty)properties.remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("Timestamp")) != null) {
            tempProp.setDateBackwardCompatibility(false);
            timestamp = tempProp.getValueAsDate();
            if (res.getEtag() == null) {
                etag = TableDeserializer.getETagFromTimestamp(tempProp.getValueAsString());
                res.setEtag(etag);
            }
        }
        if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && (options.getPropertyResolver() != null || clazzType != null)) {
            if (options.getPropertyResolver() != null) {
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    EdmType edmType;
                    String key = p.getKey();
                    String value = p.getValue().getValueAsString();
                    try {
                        edmType = options.getPropertyResolver().propertyResolver(partitionKey, rowKey, key, value);
                    }
                    catch (Exception e) {
                        throw new StorageException("InternalError", "The custom property resolver delegate threw an exception. Check the inner exception for more details.", 306, null, e);
                    }
                    try {
                        EntityProperty newProp = new EntityProperty(value, edmType);
                        newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                        properties.put(p.getKey(), newProp);
                    }
                    catch (IllegalArgumentException e) {
                        throw new StorageException("InvalidType", String.format("Failed to parse property '%s' with value '%s' as type '%s'", new Object[]{key, value, edmType}), 306, null, e);
                    }
                }
            } else if (clazzType != null) {
                if (classProperties == null) {
                    classProperties = PropertyPair.generatePropertyPairs(clazzType);
                }
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    PropertyPair propPair = classProperties.get(p.getKey());
                    if (propPair == null) continue;
                    EntityProperty newProp = new EntityProperty(p.getValue().getValueAsString(), propPair.type);
                    newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                    properties.put(p.getKey(), newProp);
                }
            }
        }
        res.setProperties(properties);
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    private static String getETagFromTimestamp(String timestampString) throws UnsupportedEncodingException {
        timestampString = URLEncoder.encode(timestampString, "UTF-8");
        return "W/\"datetime'" + timestampString + "'\"";
    }

    private static EdmType evaluateEdmType(JsonToken token, String value) {
        EdmType edmType = null;
        edmType = token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE ? EdmType.BOOLEAN : (token == JsonToken.VALUE_NUMBER_FLOAT ? EdmType.DOUBLE : (token == JsonToken.VALUE_NUMBER_INT ? EdmType.INT32 : EdmType.STRING));
        return edmType;
    }

    private static JsonParser createJsonParserFromStream(InputStream streamRef) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createParser(streamRef);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }
}

