/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.ds.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;
import org.jboss.jca.common.metadata.spec.ConfigPropertyImpl;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.capacity.CapacityFactory;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolFactory;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.security.SubjectFactory;
import org.jboss.jca.core.spi.statistics.Statistics;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersBundle;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.common.SecurityActions;
import org.jboss.logging.Messages;

public abstract class AbstractDsDeployer {
    private static DeployersBundle bundle = (DeployersBundle)Messages.getBundle(DeployersBundle.class);
    protected DeployersLogger log = this.getLogger();
    protected TransactionIntegration transactionIntegration = null;
    protected XAResourceRecoveryRegistry xaResourceRecoveryRegistry;
    private ManagementRepository managementRepository = null;
    private CachedConnectionManager ccm = null;

    public void setTransactionIntegration(TransactionIntegration value) {
        this.transactionIntegration = value;
    }

    public TransactionIntegration getTransactionIntegration() {
        return this.transactionIntegration;
    }

    public ManagementRepository getManagementRepository() {
        return this.managementRepository;
    }

    public void setManagementRepository(ManagementRepository managementRepository) {
        this.managementRepository = managementRepository;
    }

    public void setCachedConnectionManager(CachedConnectionManager value) {
        this.ccm = value;
    }

    public CachedConnectionManager getCachedConnectionManager() {
        return this.ccm;
    }

    public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
        return this.xaResourceRecoveryRegistry;
    }

    public void setXAResourceRecoveryRegistry(XAResourceRecoveryRegistry xAResourceRecoveryRegistry) {
        this.xaResourceRecoveryRegistry = xAResourceRecoveryRegistry;
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, String uniqueJdbcLocalId, String uniqueJdbcXAId, DataSources dataSources, ClassLoader parentClassLoader) throws DeployException {
        try {
            org.jboss.jca.core.api.management.DataSource mgtDataSource;
            String jndiName;
            if (this.numberOfDataSources(dataSources) > 1 && !this.verifyTypes(dataSources)) {
                throw new DeployException(bundle.deploymentFailed(url.toExternalForm()));
            }
            ArrayList<Object> cfs = new ArrayList<Object>(1);
            ArrayList<String> jndis = new ArrayList<String>(1);
            ArrayList<org.jboss.jca.core.connectionmanager.ConnectionManager> cms = new ArrayList<org.jboss.jca.core.connectionmanager.ConnectionManager>(1);
            ArrayList<XAResourceRecovery> recoveryModules = new ArrayList<XAResourceRecovery>(1);
            ArrayList<org.jboss.jca.core.api.management.DataSource> mgts = new ArrayList<org.jboss.jca.core.api.management.DataSource>(1);
            String uniqueId = uniqueJdbcLocalId != null ? uniqueJdbcLocalId : uniqueJdbcXAId;
            HashMap props = new HashMap();
            ResourceAdapter resourceAdapter = this.createRa(uniqueId, parentClassLoader);
            String resourceAdapterKey = null;
            String bootstrapContextIdentifier = null;
            if (this.needsBootstrapContext(dataSources)) {
                bootstrapContextIdentifier = BootstrapContextCoordinator.getInstance().createIdentifier(resourceAdapter.getClass().getName(), props, null);
            }
            if (uniqueJdbcLocalId != null) {
                List ds = dataSources.getDataSource();
                if (ds != null && ds.size() > 0) {
                    ClassLoader jdbcLocalDeploymentCl = this.getDeploymentClassLoader(uniqueJdbcLocalId);
                    for (DataSource dataSource : ds) {
                        if (this.log.isTraceEnabled()) {
                            this.log.tracef("DataSource=%s", this.stripPassword(dataSource.toString()));
                        }
                        if (!dataSource.isEnabled().booleanValue()) continue;
                        jndiName = this.buildJndiName(dataSource.getJndiName(), dataSource.isUseJavaContext());
                        try {
                            String dataSourceClass;
                            String driverName;
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(false);
                            org.jboss.jca.core.connectionmanager.ConnectionManager[] cm = new org.jboss.jca.core.connectionmanager.ConnectionManager[1];
                            if (dataSource.getDriverClass() == null && dataSource.getDriver() != null && dataSource instanceof DataSourceImpl) {
                                String driverClass = null;
                                if (dataSources.getDriver(dataSource.getDriver()) != null) {
                                    driverClass = dataSources.getDriver(dataSource.getDriver()).getDriverClass();
                                }
                                if (driverClass != null) {
                                    ((DataSourceImpl)dataSource).forceDriverClass(driverClass);
                                }
                            }
                            if (dataSource.getDriverClass() == null && dataSource.getDriver() != null && dataSource instanceof DataSourceImpl) {
                                String driverClass;
                                driverName = dataSource.getDriver();
                                String moduleId = null;
                                if (dataSources.getDriver(dataSource.getDriver()) != null) {
                                    moduleId = dataSources.getDriver(dataSource.getDriver()).getModule();
                                }
                                if ((driverClass = this.getDriver(driverName, moduleId)) != null) {
                                    ((DataSourceImpl)dataSource).forceDriverClass(driverClass);
                                }
                            }
                            if (dataSource.getDataSourceClass() == null && dataSource.getDriver() != null && dataSource instanceof DataSourceImpl && dataSources.getDriver(driverName = dataSource.getDriver()) != null && (dataSourceClass = dataSources.getDriver(driverName).getDataSourceClass()) != null) {
                                ((DataSourceImpl)dataSource).forceDataSourceClass(dataSourceClass);
                            }
                            Object cf = this.deployDataSource(dataSource, jndiName, uniqueJdbcLocalId, cm, resourceAdapter, mgtDataSource, jdbcLocalDeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            cms.add(cm[0]);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error("Error during the deployment of " + jndiName, t);
                        }
                    }
                }
            } else if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                this.log.error("Deployment of datasources disabled since jdbc-local.rar couldn't be found");
            }
            if (uniqueJdbcXAId != null) {
                List xads = dataSources.getXaDataSource();
                if (xads != null && xads.size() > 0) {
                    ClassLoader jdbcXADeploymentCl = this.getDeploymentClassLoader(uniqueJdbcXAId);
                    for (XaDataSource xaDataSource : xads) {
                        if (this.log.isTraceEnabled()) {
                            this.log.tracef("XaDataSource=%s", this.stripPassword(xaDataSource.toString()));
                        }
                        if (!xaDataSource.isEnabled().booleanValue()) continue;
                        jndiName = this.buildJndiName(xaDataSource.getJndiName(), xaDataSource.isUseJavaContext());
                        try {
                            mgtDataSource = new org.jboss.jca.core.api.management.DataSource(true);
                            XAResourceRecovery[] recovery = new XAResourceRecovery[1];
                            org.jboss.jca.core.connectionmanager.ConnectionManager[] cm = new org.jboss.jca.core.connectionmanager.ConnectionManager[1];
                            if (xaDataSource.getXaDataSourceClass() == null && xaDataSource.getDriver() != null && xaDataSource instanceof XADataSourceImpl) {
                                ((XADataSourceImpl)xaDataSource).forceXaDataSourceClass(dataSources.getDriver(xaDataSource.getDriver()).getXaDataSourceClass());
                            }
                            Object cf = this.deployXADataSource(xaDataSource, jndiName, uniqueJdbcXAId, cm, resourceAdapter, recovery, mgtDataSource, jdbcXADeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                            cms.add(cm[0]);
                            recoveryModules.add(recovery[0]);
                            mgts.add(mgtDataSource);
                        }
                        catch (Throwable t) {
                            this.log.error("Error during the deployment of " + jndiName, t);
                        }
                    }
                }
            } else if (dataSources.getXaDataSource() != null && dataSources.getXaDataSource().size() > 0) {
                this.log.error("Deployment of XA datasources disabled since jdbc-xa.rar couldn't be found");
            }
            resourceAdapterKey = this.registerResourceAdapterToResourceAdapterRepository(resourceAdapter);
            if (bootstrapContextIdentifier != null) {
                this.startContext(resourceAdapter, bootstrapContextIdentifier);
            }
            return new CommonDeployment(url, deploymentName, true, resourceAdapter, resourceAdapterKey, bootstrapContextIdentifier, cfs.toArray(new Object[cfs.size()]), jndis.toArray(new String[jndis.size()]), cms.toArray(new org.jboss.jca.core.connectionmanager.ConnectionManager[cms.size()]), null, null, recoveryModules.toArray(new XAResourceRecovery[recoveryModules.size()]), null, mgts.toArray(new org.jboss.jca.core.api.management.DataSource[mgts.size()]), parentClassLoader, this.log);
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new DeployException(bundle.deploymentFailed(url.toExternalForm()), t);
        }
    }

    protected String buildJndiName(String jndiName, Boolean javaContext) {
        if (javaContext != null) {
            if (javaContext.booleanValue() && !jndiName.startsWith("java:")) {
                jndiName = "java:" + jndiName;
            } else if (!javaContext.booleanValue() && jndiName.startsWith("java:")) {
                jndiName = jndiName.substring(6);
            }
        }
        return jndiName;
    }

    protected String getDriver(String driverName, String moduleId) {
        return null;
    }

    protected int numberOfDataSources(DataSources datasources) {
        return datasources.getDataSource().size() + datasources.getXaDataSource().size();
    }

    protected boolean verifyTypes(DataSources datasources) {
        boolean hasNonJTA = false;
        boolean hasJTA = datasources.getXaDataSource().size() > 0;
        for (DataSource ds : datasources.getDataSource()) {
            if (ds.isJTA().booleanValue()) {
                hasJTA = true;
                continue;
            }
            hasNonJTA = true;
        }
        if (hasJTA && !hasNonJTA) {
            return true;
        }
        return hasNonJTA && !hasJTA;
    }

    protected boolean needsBootstrapContext(DataSources datasources) {
        if (datasources.getXaDataSource().size() > 0) {
            return true;
        }
        for (DataSource ds : datasources.getDataSource()) {
            if (!ds.isJTA().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Object deployDataSource(DataSource ds, String jndiName, String uniqueId, org.jboss.jca.core.connectionmanager.ConnectionManager[] cma, ResourceAdapter resourceAdapter, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        DsPool dsPool;
        ManagedConnectionPoolFactory mcpf;
        String mcpClass;
        ManagedConnectionFactory mcf = this.createMcf(ds, uniqueId, cl);
        this.associateResourceAdapter(resourceAdapter, mcf);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        PoolConfiguration pc = this.createPoolConfiguration((org.jboss.jca.common.api.metadata.common.Pool)ds.getPool(), ds.getTimeOut(), ds.getValidation());
        if (!(ds.getValidation() == null || pc.isValidateOnMatch() || pc.isBackgroundValidation() || ds.getValidation().getValidConnectionChecker() == null && ds.getValidation().getCheckValidConnectionSql() == null)) {
            this.log.enablingValidateOnMatch(jndiName);
            pc.setValidateOnMatch(true);
        }
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        boolean isCRI = false;
        boolean allowMultipleUsers = false;
        if (ds.getPool() != null && ds.getPool().isAllowMultipleUsers() != null && ds.getPool().isAllowMultipleUsers().booleanValue()) {
            strategy = PoolStrategy.POOL_BY_CRI;
            allowMultipleUsers = true;
            pc.setMinSize(0);
            isCRI = true;
        }
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
                isCRI = false;
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                if (!allowMultipleUsers) {
                    strategy = PoolStrategy.POOL_BY_SUBJECT;
                } else {
                    strategy = PoolStrategy.POOL_BY_SUBJECT_AND_CRI;
                    pc.setMinSize(0);
                    isCRI = true;
                }
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        if ((mcpClass = ds.getMcp()) == null && (mcpf = new ManagedConnectionPoolFactory()).isOverride()) {
            mcpClass = mcpf.getDefaultImplementation();
        }
        if (mcpClass == null) {
            mcpClass = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreConcurrentLinkedDequeManagedConnectionPool";
        }
        Pool pool = pf.create(strategy, mcf, pc, false, true, mcpClass);
        if (ds.getPool() != null && ds.getPool().getCapacity() != null) {
            pool.setCapacity(CapacityFactory.create((Capacity)ds.getPool().getCapacity(), (boolean)isCRI));
        }
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
        }
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        if (mcf instanceof Statistics) {
            mgtDs.setStatistics(((Statistics)mcf).getStatistics());
        }
        this.log.debugf("Adding management datasource: %s", mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        if (ds.getPool() != null) {
            flushStrategy = ds.getPool().getFlushStrategy();
        }
        boolean connectable = ds.isConnectable() == null ? false : ds.isConnectable();
        Boolean tracking = ds.isTracking();
        Boolean enlistmentTrace = ds.isEnlistmentTrace();
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        Object cm = null;
        cm = ds.isJTA() != false ? cmf.createTransactional(TransactionSupport.TransactionSupportLevel.LocalTransaction, pool, this.getSubjectFactory(securityDomain), securityDomain, ds.isUseCcm().booleanValue(), this.getCachedConnectionManager(), true, true, connectable, tracking, enlistmentTrace, flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), null, null, null, null, null) : cmf.createNonTransactional(TransactionSupport.TransactionSupportLevel.NoTransaction, pool, this.getSubjectFactory(securityDomain), securityDomain, ds.isUseCcm().booleanValue(), this.getCachedConnectionManager(), true, true, connectable, tracking, flushStrategy, allocationRetry, allocationRetryWaitMillis);
        cm.setJndiName(jndiName);
        cma[0] = cm;
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        this.injectValue(mcf, "setJndiName", jndiName);
        if (ds.isSpy().booleanValue()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
        }
        if (ds.isJTA().booleanValue()) {
            this.injectValue(mcf, "setJTA", Boolean.TRUE);
        } else {
            this.injectValue(mcf, "setJTA", Boolean.FALSE);
        }
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        if (ds.getPool() != null && (dsPool = ds.getPool()).getConnectionListener() != null) {
            this.injectValue(mcf, "setConnectionListenerClassName", dsPool.getConnectionListener().getClassName());
            Map mps = dsPool.getConnectionListener().getConfigPropertiesMap();
            if (mps.size() > 0) {
                StringBuilder connectionListenerProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    connectionListenerProperties.append((String)entry.getKey());
                    connectionListenerProperties.append("|");
                    connectionListenerProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    connectionListenerProperties.append(",");
                }
                this.injectValue(mcf, "setConnectionListenerProperties", connectionListenerProperties.toString());
            }
        }
        if (pool instanceof PrefillPool) {
            PrefillPool pp = (PrefillPool)pool;
            SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
            Subject subject = null;
            if (subjectFactory != null) {
                subject = this.createSubject(subjectFactory, securityDomain, mcf, jndiName);
            }
            pp.prefill(subject, null, false);
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private Object deployXADataSource(XaDataSource ds, String jndiName, String uniqueId, org.jboss.jca.core.connectionmanager.ConnectionManager[] cma, ResourceAdapter resourceAdapter, XAResourceRecovery[] recovery, org.jboss.jca.core.api.management.DataSource mgtDs, ClassLoader cl) throws Throwable {
        DsXaPool dsXaPool;
        DsXaPool dsXaPool2;
        ManagedConnectionPoolFactory mcpf;
        String mcpClass;
        DsXaPool dsXaPool3;
        ManagedConnectionFactory mcf = this.createMcf(ds, uniqueId, cl);
        this.associateResourceAdapter(resourceAdapter, mcf);
        this.initAndInjectClassLoaderPlugin(mcf, (CommonDataSource)ds);
        PoolConfiguration pc = this.createPoolConfiguration((org.jboss.jca.common.api.metadata.common.Pool)ds.getXaPool(), ds.getTimeOut(), ds.getValidation());
        if (!(ds.getValidation() == null || pc.isValidateOnMatch() || pc.isBackgroundValidation() || ds.getValidation().getValidConnectionChecker() == null && ds.getValidation().getCheckValidConnectionSql() == null)) {
            this.log.enablingValidateOnMatch(jndiName);
            pc.setValidateOnMatch(true);
        }
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        if (ds.getXaPool() != null && ds.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = ds.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        PoolStrategy strategy = PoolStrategy.ONE_POOL;
        boolean isCRI = false;
        boolean allowMultipleUsers = false;
        if (ds.getXaPool() != null && (dsXaPool3 = ds.getXaPool()).isAllowMultipleUsers() != null && dsXaPool3.isAllowMultipleUsers().booleanValue()) {
            strategy = PoolStrategy.POOL_BY_CRI;
            allowMultipleUsers = true;
            pc.setMinSize(0);
            isCRI = true;
        }
        String securityDomain = null;
        if (ds.getSecurity() != null) {
            if (ds.getSecurity().getReauthPlugin() != null) {
                strategy = PoolStrategy.REAUTH;
                securityDomain = ds.getSecurity().getSecurityDomain();
                isCRI = false;
            } else if (ds.getSecurity().getSecurityDomain() != null) {
                if (!allowMultipleUsers) {
                    strategy = PoolStrategy.POOL_BY_SUBJECT;
                } else {
                    strategy = PoolStrategy.POOL_BY_SUBJECT_AND_CRI;
                    pc.setMinSize(0);
                    isCRI = true;
                }
                securityDomain = ds.getSecurity().getSecurityDomain();
            }
        }
        if ((mcpClass = ds.getMcp()) == null && (mcpf = new ManagedConnectionPoolFactory()).isOverride()) {
            mcpClass = mcpf.getDefaultImplementation();
        }
        if (mcpClass == null) {
            mcpClass = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreConcurrentLinkedDequeManagedConnectionPool";
        }
        Pool pool = pf.create(strategy, mcf, pc, noTxSeparatePool.booleanValue(), true, mcpClass);
        if (ds.getXaPool() != null && (dsXaPool2 = ds.getXaPool()).getCapacity() != null) {
            pool.setCapacity(CapacityFactory.create((Capacity)dsXaPool2.getCapacity(), (boolean)isCRI));
        }
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = Defaults.INTERLEAVING;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean wrapXAResource = Defaults.WRAP_XA_RESOURCE;
        Boolean padXid = Defaults.PAD_XID;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = ds.getTimeOut().getXaResourceTimeout();
        }
        if (ds.getXaPool() != null) {
            interleaving = ds.getXaPool().isInterleaving();
            isSameRMOverride = ds.getXaPool().isSameRmOverride();
            wrapXAResource = ds.getXaPool().isWrapXaResource();
            padXid = ds.getXaPool().isPadXid();
        }
        pool.setInterleaving(interleaving.booleanValue());
        mgtDs.setJndiName(jndiName);
        mgtDs.setPoolConfiguration(pc);
        mgtDs.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
        if (mcf instanceof Statistics) {
            mgtDs.setStatistics(((Statistics)mcf).getStatistics());
        }
        this.log.debugf("Adding management datasource: %s", mgtDs);
        this.getManagementRepository().getDataSources().add(mgtDs);
        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
        if (ds.getXaPool() != null) {
            flushStrategy = ds.getXaPool().getFlushStrategy();
        }
        boolean connectable = ds.isConnectable() == null ? false : ds.isConnectable();
        Boolean tracking = ds.isTracking();
        Boolean enlistmentTrace = ds.isEnlistmentTrace();
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, ds.isUseCcm().booleanValue(), this.getCachedConnectionManager(), true, true, connectable, tracking, enlistmentTrace, flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        cma[0] = cm;
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        this.injectValue(mcf, "setJndiName", jndiName);
        if (ds.isSpy().booleanValue()) {
            this.injectValue(mcf, "setSpy", Boolean.TRUE);
        }
        this.injectValue(mcf, "setURLProperty", ds.getUrlProperty());
        if (strategy == PoolStrategy.REAUTH) {
            this.injectValue(mcf, "setReauthEnabled", Boolean.TRUE);
            this.injectValue(mcf, "setReauthPluginClassName", ds.getSecurity().getReauthPlugin().getClassName());
            Map mps = ds.getSecurity().getReauthPlugin().getConfigPropertiesMap();
            if (mps.size() > 0) {
                StringBuilder reauthPluginProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    reauthPluginProperties.append((String)entry.getKey());
                    reauthPluginProperties.append("|");
                    reauthPluginProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    reauthPluginProperties.append(",");
                }
                this.injectValue(mcf, "setReauthPluginProperties", reauthPluginProperties.toString());
            }
        }
        if (ds.getXaPool() != null && (dsXaPool = ds.getXaPool()).getConnectionListener() != null) {
            this.injectValue(mcf, "setConnectionListenerClassName", dsXaPool.getConnectionListener().getClassName());
            Map mps = dsXaPool.getConnectionListener().getConfigPropertiesMap();
            if (mps.size() > 0) {
                StringBuilder connectionListenerProperties = new StringBuilder();
                Iterator entryIterator = mps.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    connectionListenerProperties.append((String)entry.getKey());
                    connectionListenerProperties.append("|");
                    connectionListenerProperties.append((String)entry.getValue());
                    if (!entryIterator.hasNext()) continue;
                    connectionListenerProperties.append(",");
                }
                this.injectValue(mcf, "setConnectionListenerProperties", connectionListenerProperties.toString());
            }
        }
        Recovery recoveryMD = ds.getRecovery();
        String defaultSecurityDomain = null;
        String defaultUserName = null;
        String defaultPassword = null;
        if (ds.getSecurity() != null) {
            defaultSecurityDomain = ds.getSecurity().getSecurityDomain();
            defaultUserName = ds.getSecurity().getUserName();
            defaultPassword = ds.getSecurity().getPassword();
        }
        String recoverSecurityDomain = defaultSecurityDomain;
        String recoverUser = defaultUserName;
        String recoverPassword = defaultPassword;
        XAResourceRecovery recoveryImpl = null;
        boolean enableRecovery = false;
        if (recoveryMD == null || !recoveryMD.getNoRecovery().booleanValue()) {
            Credential credential;
            enableRecovery = true;
            Credential credential2 = credential = recoveryMD != null ? recoveryMD.getCredential() : null;
            if (credential != null) {
                if (credential.getSecurityDomain() != null) {
                    recoverSecurityDomain = credential.getSecurityDomain();
                }
                if (credential.getUserName() != null) {
                    recoverUser = credential.getUserName();
                }
                if (credential.getPassword() != null) {
                    recoverPassword = credential.getPassword();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("RecoverUser=" + recoverUser);
                this.log.debug("RecoverSecurityDomain=" + recoverSecurityDomain);
            }
            if (recoverUser != null && !recoverUser.trim().equals("") && recoverPassword != null && !recoverPassword.trim().equals("") || recoverSecurityDomain != null && !recoverSecurityDomain.trim().equals("")) {
                DefaultRecoveryPlugin plugin = null;
                if (recoveryMD != null && recoveryMD.getRecoverPlugin() != null && recoveryMD.getRecoverPlugin().getClassName() != null) {
                    ArrayList<ConfigPropertyImpl> configProperties = new ArrayList<ConfigPropertyImpl>(recoveryMD.getRecoverPlugin().getConfigPropertiesMap().size());
                    for (Map.Entry property : recoveryMD.getRecoverPlugin().getConfigPropertiesMap().entrySet()) {
                        ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), XsdString.NULL_XSDSTRING, new XsdString((String)property.getValue(), null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
                        configProperties.add(c);
                    }
                    plugin = (RecoveryPlugin)this.initAndInject(recoveryMD.getRecoverPlugin().getClassName(), configProperties, cl);
                } else {
                    plugin = new DefaultRecoveryPlugin();
                }
                XAResourceStatistics xastat = null;
                if (pool.getStatistics() != null && pool.getStatistics() instanceof XAResourceStatistics) {
                    xastat = (XAResourceStatistics)pool.getStatistics();
                }
                recoveryImpl = this.getTransactionIntegration().createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, recoverUser, recoverPassword, recoverSecurityDomain, this.getSubjectFactory(recoverSecurityDomain), (RecoveryPlugin)plugin, xastat);
            }
        }
        if (enableRecovery && this.getTransactionIntegration().getRecoveryRegistry() != null) {
            if (recoveryImpl != null) {
                recoveryImpl.setJndiName(cm.getJndiName());
                recoveryImpl.initialize();
                this.getTransactionIntegration().getRecoveryRegistry().addXAResourceRecovery(recoveryImpl);
                recovery[0] = recoveryImpl;
            } else {
                this.log.missingRecovery(cm.getJndiName());
            }
        }
        if (pool instanceof PrefillPool) {
            PrefillPool pp = (PrefillPool)pool;
            SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
            Subject subject = null;
            if (subjectFactory != null) {
                subject = this.createSubject(subjectFactory, securityDomain, mcf, jndiName);
            }
            pp.prefill(subject, null, noTxSeparatePool.booleanValue());
        }
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    protected void startContext(ResourceAdapter resourceAdapter, String bootstrapContextIdentifier) throws DeployException {
        try {
            CloneableBootstrapContext cbc = BootstrapContextCoordinator.getInstance().createBootstrapContext(bootstrapContextIdentifier, null);
            cbc.setResourceAdapter(resourceAdapter);
            resourceAdapter.start((BootstrapContext)cbc);
        }
        catch (Throwable t) {
            throw new DeployException(bundle.unableToStartResourceAdapter(resourceAdapter.getClass().getName()), t);
        }
    }

    protected void associateResourceAdapter(ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                ResourceAdapterAssociation raa = (ResourceAdapterAssociation)object;
                raa.setResourceAdapter(resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException(bundle.unableToAssociate(object.getClass().getName()), t);
            }
        }
    }

    protected abstract ResourceAdapter createRa(String var1, ClassLoader var2) throws NotFoundException, Exception, DeployException;

    protected abstract String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter var1);

    protected abstract ManagedConnectionFactory createMcf(XaDataSource var1, String var2, ClassLoader var3) throws NotFoundException, Exception, DeployException;

    protected abstract ManagedConnectionFactory createMcf(DataSource var1, String var2, ClassLoader var3) throws NotFoundException, Exception, DeployException;

    private PoolConfiguration createPoolConfiguration(org.jboss.jca.common.api.metadata.common.Pool pp, TimeOut tp, Validation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getInitialPoolSize() != null) {
                pc.setInitialSize(pp.getInitialPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
            if (pp.isFair() != null) {
                pc.setFair(pp.isFair().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeoutMinutes(tp.getIdleTimeoutMinutes().intValue());
            }
        }
        if (vp != null) {
            if (vp.isValidateOnMatch() != null) {
                pc.setValidateOnMatch(vp.isValidateOnMatch().booleanValue());
            }
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMillis() != null) {
                pc.setBackgroundValidationMillis((long)vp.getBackgroundValidationMillis().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    private void injectValue(Object o, String methodName, Object value) throws Exception {
        Method[] methods = SecurityActions.getMethods(o.getClass());
        boolean found = false;
        for (int i = 0; !found && i < methods.length; ++i) {
            Method m = methods[i];
            SecurityActions.setAccessible(m);
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            m.invoke(o, value);
            found = true;
        }
    }

    private String stripPassword(String str) {
        if (str.indexOf("<password>") == -1) {
            return str;
        }
        Pattern pattern = Pattern.compile("<password>[^<]*</password>");
        String[] strs = pattern.split(str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            String s = strs[i];
            sb.append(s);
            if (i >= strs.length - 1) continue;
            sb.append("<password>****</password>");
        }
        return sb.toString();
    }

    protected abstract ClassLoader getDeploymentClassLoader(String var1);

    protected abstract String[] bindConnectionFactory(String var1, String var2, Object var3) throws Throwable;

    protected abstract Object initAndInject(String var1, List<? extends ConfigProperty> var2, ClassLoader var3) throws DeployException;

    protected void initAndInjectClassLoaderPlugin(ManagedConnectionFactory mcf, CommonDataSource dsMetadata) throws DeployException {
    }

    protected abstract SubjectFactory getSubjectFactory(String var1) throws DeployException;

    protected abstract DeployersLogger getLogger();

    protected Subject createSubject(final SubjectFactory subjectFactory, final String securityDomain, final ManagedConnectionFactory mcf, final String jndiName) {
        if (subjectFactory == null) {
            throw new IllegalArgumentException("SubjectFactory is null");
        }
        if (securityDomain == null) {
            throw new IllegalArgumentException("SecurityDomain is null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                try {
                    Subject subject = subjectFactory.createSubject(securityDomain);
                    Set<PasswordCredential> pcs = subject.getPrivateCredentials(PasswordCredential.class);
                    if (pcs.size() > 0) {
                        for (PasswordCredential pc : pcs) {
                            pc.setManagedConnectionFactory(mcf);
                        }
                    }
                    if (AbstractDsDeployer.this.log.isDebugEnabled()) {
                        AbstractDsDeployer.this.log.debug("Subject=" + subject);
                    }
                    return subject;
                }
                catch (Throwable t) {
                    AbstractDsDeployer.this.log.error("Exception during createSubject() for " + jndiName + ": " + t.getMessage(), t);
                    return null;
                }
            }
        });
    }
}

