/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class ServerSuspendHandler
implements OperationStepHandler {
    protected static final String OPERATION_NAME = "suspend";
    public static final ServerSuspendHandler INSTANCE = new ServerSuspendHandler();
    protected static final SimpleAttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT).setDefaultValue(new ModelNode(0))).setAllowNull(true)).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("suspend", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setParameters(new AttributeDefinition[]{TIMEOUT}).setRuntimeOnly().build();
    public static final SimpleOperationDefinition DOMAIN_DEFINITION = new SimpleOperationDefinitionBuilder("suspend", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setParameters(new AttributeDefinition[]{TIMEOUT}).setPrivateEntry().withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY, OperationEntry.Flag.RUNTIME_ONLY}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceRegistry registry = context.getServiceRegistry(false);
                ServiceController suspendControllerServiceController = registry.getRequiredService(SuspendController.SERVICE_NAME);
                final SuspendController suspendController = (SuspendController)suspendControllerServiceController.getValue();
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicBoolean cancelled = new AtomicBoolean();
                OperationListener operationListener = new OperationListener(){

                    @Override
                    public void suspendStarted() {
                    }

                    @Override
                    public void complete() {
                        suspendController.removeListener(this);
                        latch.countDown();
                    }

                    @Override
                    public void cancelled() {
                        suspendController.removeListener(this);
                        cancelled.set(true);
                        latch.countDown();
                    }

                    @Override
                    public void timeout() {
                        suspendController.removeListener(this);
                        latch.countDown();
                    }
                };
                suspendController.addListener(operationListener);
                suspendController.suspend(timeout > 0 ? (long)(timeout * 1000) : (long)timeout);
                if (timeout != 0) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (cancelled.get()) {
                    context.setRollbackOnly();
                }
                context.completeStep((OperationContext.ResultHandler)new RollbackHandler(suspendController));
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    private static final class RollbackHandler
    implements OperationContext.ResultHandler {
        private final SuspendController controller;

        private RollbackHandler(SuspendController controller) {
            this.controller = controller;
        }

        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                this.controller.resume();
            }
        }
    }
}

