/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.orientdb;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.Configuration;
import org.wildfly.extension.nosql.driver.OrientClientConnectionsService;
import org.wildfly.extension.nosql.driver.OrientInteraction;
import org.wildfly.extension.nosql.subsystem.orientdb.HostDefinition;
import org.wildfly.extension.nosql.subsystem.orientdb.OrientDriverExtension;
import org.wildfly.extension.nosql.subsystem.orientdb.OrientSubsystemService;
import org.wildfly.nosql.common.ConnectionServiceAccess;

final class OrientDefinition
extends PersistentResourceDefinition {
    private static final List<PersistentResourceDefinition> CHILDREN = Collections.singletonList(HostDefinition.INSTANCE);
    private static final SimpleAttributeDefinition ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("id", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition DATABASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("database", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(false)).build();
    private static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition MAX_PARTITION_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-partition-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    private static final SimpleAttributeDefinition MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ID, DATABASE, JNDI_NAME, MODULE, SECURITY_DOMAIN, MAX_PARTITION_SIZE, MAX_POOL_SIZE};
    static final OrientDefinition INSTANCE = new OrientDefinition();

    private OrientDefinition() {
        super(OrientDriverExtension.ORIENT_PATH, (ResourceDescriptionResolver)OrientDriverExtension.getResourceDescriptionResolver("orient"), (OperationStepHandler)OrientAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    private static final class OrientAdd
    extends AbstractAddStepHandler {
        private static final OrientAdd INSTANCE = new OrientAdd();

        private OrientAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode profileEntry = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            Configuration configuration = this.getConfiguration(profileEntry);
            String outboundSocketBinding = this.getOutboundSocketBinding(profileEntry);
            this.startServices(context, configuration, outboundSocketBinding);
        }

        private void startServices(OperationContext context, Configuration configuration, String outboundSocketBinding) {
            ServiceName connectionsServiceName = ConnectionServiceAccess.serviceName((String)configuration.getProfileName());
            OrientInteraction orientInteraction = new OrientInteraction(configuration);
            OrientClientConnectionsService connectionsService = new OrientClientConnectionsService(configuration, orientInteraction);
            ServiceBuilder connectionsServiceBuilder = context.getServiceTarget().addService(connectionsServiceName, (Service)connectionsService);
            connectionsServiceBuilder.addDependency(OrientSubsystemService.SERVICE_NAME, (Injector)new CastingInjector(connectionsService.getOrientSubsystemServiceInjectedValue(), OrientSubsystemService.class));
            ServiceName outboundSocketBindingServiceName = context.getCapabilityServiceName("org.wildfly.network.outbound-socket-binding", outboundSocketBinding, OutboundSocketBinding.class);
            connectionsServiceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, outboundSocketBindingServiceName, (Injector)new CastingInjector(connectionsService.getOutboundSocketBindingInjectedValue(), OutboundSocketBinding.class));
            if (configuration.getSecurityDomain() != null) {
                connectionsServiceBuilder.addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, connectionsService.getSubjectFactoryInjector());
            }
            connectionsServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            this.bindJndi(context, connectionsServiceName, configuration.getJndiName(), orientInteraction.getDatabasePoolClass());
        }

        private <T> void bindJndi(OperationContext context, ServiceName serviceName, String jndiName, final Class<T> clazz) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            final BinderService binderService = new BinderService(bindInfo.getBindName());
            context.getServiceTarget().addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(OrientSubsystemService.SERVICE_NAME).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(serviceName, OrientClientConnectionsService.class, (Injector)new Injector<OrientClientConnectionsService>(){

                public void inject(OrientClientConnectionsService value) throws InjectionException {
                    binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue(value.unwrap(clazz))));
                }

                public void uninject() {
                    binderService.getNamingStoreInjector().uninject();
                }
            }).install();
        }

        private Configuration getConfiguration(ModelNode profileEntry) {
            Configuration.Builder builder = new Configuration.Builder();
            if (profileEntry.hasDefined("id")) {
                builder.profileName(profileEntry.get("id").asString());
            }
            if (profileEntry.hasDefined("database")) {
                builder.database(profileEntry.get("database").asString());
            }
            if (profileEntry.hasDefined("jndi-name")) {
                builder.jndiName(profileEntry.get("jndi-name").asString());
            }
            if (profileEntry.hasDefined("module")) {
                builder.moduleName(profileEntry.get("module").asString());
            }
            if (profileEntry.hasDefined("security-domain")) {
                builder.securityDomain(profileEntry.get("security-domain").asString());
            }
            if (profileEntry.hasDefined("max-partition-size")) {
                builder.maxPartitionSize(profileEntry.get("max-partition-size").asInt());
            }
            if (profileEntry.hasDefined("max-pool-size")) {
                builder.maxPoolSize(profileEntry.get("max-pool-size").asInt());
            }
            return builder.build();
        }

        private String getOutboundSocketBinding(ModelNode profileEntry) {
            if (profileEntry.hasDefined("host")) {
                ModelNode hostModels = profileEntry.get("host");
                for (ModelNode host : hostModels.asList()) {
                    for (ModelNode hostEntry : host.get(0).asList()) {
                        if (!hostEntry.hasDefined("outbound-socket-binding-ref")) continue;
                        return hostEntry.get("outbound-socket-binding-ref").asString();
                    }
                }
            }
            return null;
        }
    }
}

