/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ChannelFactoryTransport
extends JGroupsTransport {
    private final ChannelFactory factory;

    public ChannelFactoryTransport(ChannelFactory factory) {
        this.factory = factory;
    }

    @Inject
    public void setConfiguration(GlobalConfiguration config) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.globalJmxStatistics().read(config.globalJmxStatistics()).disable();
        TransportConfiguration transport = config.transport();
        builder.transport().clusterName(transport.clusterName()).distributedSyncTimeout(transport.distributedSyncTimeout()).initialClusterSize(transport.initialClusterSize()).initialClusterTimeout(transport.initialClusterTimeout(), TimeUnit.MILLISECONDS).machineId(transport.machineId()).nodeName(transport.nodeName()).rackId(transport.rackId()).siteId(transport.siteId()).transport(transport.transport()).withProperties((Properties)transport.properties());
        super.setConfiguration(builder.build());
    }

    protected void initRPCDispatcher() {
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, (JGroupsTransport)this, this.globalHandler, this.getTimeoutExecutor(), this.timeService);
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller){

            public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
                return ChannelFactoryTransport.this.isUnknownForkResponse(ByteBuffer.wrap(buffer, offset, length)) ? CacheNotFoundResponse.INSTANCE : super.objectFromBuffer(buffer, offset, length);
            }
        };
        this.dispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.start();
    }

    boolean isUnknownForkResponse(ByteBuffer response) {
        return this.factory.isUnknownForkResponse(response);
    }

    protected void initChannel() {
        try {
            this.channel = this.factory.createChannel(this.configuration.globalJmxStatistics().cacheManagerName());
            this.channel.setDiscardOwnMessages(false);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

