/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;

public class OSQLFilter
extends OSQLPredicate
implements OCommandPredicate {
    public OSQLFilter(String iText, OCommandContext iContext, String iFilterKeyword) {
        if (iText == null) {
            throw new IllegalArgumentException("Filter expression is null");
        }
        this.context = iContext;
        this.parserText = iText;
        this.parserTextUpperCase = iText.toUpperCase();
        try {
            int lastPos = this.parserGetCurrentPosition();
            String lastText = this.parserText;
            String lastTextUpperCase = this.parserTextUpperCase;
            this.text(this.parserText.substring(lastPos));
            this.parserText = lastText;
            this.parserTextUpperCase = lastTextUpperCase;
            this.parserMoveCurrentPosition(lastPos);
        }
        catch (OQueryParsingException e) {
            if (e.getText() == null) {
                throw OException.wrapException(new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition()), e);
            }
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new OQueryParsingException("Error on parsing query", this.parserText, this.parserGetCurrentPosition()), e);
        }
        this.rootCondition = this.resetOperatorPrecedence(this.rootCondition);
    }

    private OSQLFilterCondition resetOperatorPrecedence(OSQLFilterCondition iCondition) {
        if (iCondition == null) {
            return iCondition;
        }
        if (iCondition.left != null && iCondition.left instanceof OSQLFilterCondition) {
            iCondition.left = this.resetOperatorPrecedence((OSQLFilterCondition)iCondition.left);
        }
        if (iCondition.right != null && iCondition.right instanceof OSQLFilterCondition) {
            OSQLFilterCondition right = (OSQLFilterCondition)iCondition.right;
            iCondition.right = this.resetOperatorPrecedence(right);
            if (iCondition.operator != null && !right.inBraces && right.operator != null && right.operator.precedence < iCondition.operator.precedence) {
                OSQLFilterCondition newLeft = new OSQLFilterCondition(iCondition.left, iCondition.operator, right.left);
                right.setLeft(newLeft);
                this.resetOperatorPrecedence(right);
                return right;
            }
        }
        return iCondition;
    }

    @Override
    public Object evaluate(OIdentifiable iRecord, ODocument iCurrentResult, OCommandContext iContext) {
        if (this.rootCondition == null) {
            return true;
        }
        return this.rootCondition.evaluate(iRecord, iCurrentResult, iContext);
    }

    @Override
    public OSQLFilterCondition getRootCondition() {
        return this.rootCondition;
    }

    @Override
    public String toString() {
        if (this.rootCondition != null) {
            return "Parsed: " + this.rootCondition.toString();
        }
        return "Unparsed: " + this.parserText;
    }
}

