/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Month;
import java.time.MonthDay;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;
import org.wildfly.clustering.marshalling.spi.time.MonthExternalizer;

public class MonthDayExternalizer
implements Externalizer<MonthDay> {
    public void writeObject(ObjectOutput output, MonthDay monthDay) throws IOException {
        MonthExternalizer.INSTANCE.writeObject(output, (Object)monthDay.getMonth());
        IndexExternalizer.UNSIGNED_BYTE.writeData(output, monthDay.getDayOfMonth());
    }

    public MonthDay readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Month month = (Month)MonthExternalizer.INSTANCE.readObject(input);
        int day = IndexExternalizer.UNSIGNED_BYTE.readData(input);
        return MonthDay.of(month, day);
    }

    public Class<MonthDay> getTargetClass() {
        return MonthDay.class;
    }
}

