/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.MultiLoadOptions;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DynamicBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    private static final Logger log = Logger.getLogger(DynamicBatchingEntityLoaderBuilder.class);
    public static final DynamicBatchingEntityLoaderBuilder INSTANCE = new DynamicBatchingEntityLoaderBuilder();

    public List multiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        if (loadOptions.isOrderReturnEnabled()) {
            return this.performOrderedMultiLoad(persister, ids, session, loadOptions);
        }
        return this.performUnorderedMultiLoad(persister, ids, session, loadOptions);
    }

    private List performOrderedMultiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        EntityEntry entry;
        EntityKey entityKey;
        assert (loadOptions.isOrderReturnEnabled());
        ArrayList result = CollectionHelper.arrayList(ids.length);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(persister.getIdentifierType().getColumnSpan(session.getFactory()), ids.length);
        ArrayList<Serializable> idsInBatch = new ArrayList<Serializable>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        for (int i = 0; i < ids.length; ++i) {
            Object managedEntity;
            Serializable id = ids[i];
            entityKey = new EntityKey(id, persister);
            if (loadOptions.isSessionCheckingEnabled() && (managedEntity = session.getPersistenceContext().getEntity(entityKey)) != null) {
                if (!(loadOptions.isReturnOfDeletedEntitiesEnabled() || (entry = session.getPersistenceContext().getEntry(managedEntity)).getStatus() != Status.DELETED && entry.getStatus() != Status.GONE)) {
                    result.add(i, null);
                    continue;
                }
                result.add(i, managedEntity);
                continue;
            }
            idsInBatch.add(ids[i]);
            if (idsInBatch.size() >= maxBatchSize) {
                this.performOrderedBatchLoad(idsInBatch, lockOptions, persister, session);
            }
            result.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            this.performOrderedBatchLoad(idsInBatch, lockOptions, persister, session);
        }
        for (Integer position : elementPositionsLoadedByBatch) {
            entityKey = (EntityKey)result.get(position);
            Object entity = session.getPersistenceContext().getEntity(entityKey);
            if (!(entity == null || loadOptions.isReturnOfDeletedEntitiesEnabled() || (entry = session.getPersistenceContext().getEntry(entity)).getStatus() != Status.DELETED && entry.getStatus() != Status.GONE)) {
                entity = null;
            }
            result.set(position, entity);
        }
        return result;
    }

    private void performOrderedBatchLoad(List<Serializable> idsInBatch, LockOptions lockOptions, OuterJoinLoadable persister, SessionImplementor session) {
        int batchSize = idsInBatch.size();
        DynamicEntityLoader batchingLoader = new DynamicEntityLoader(persister, batchSize, lockOptions, session.getFactory(), session.getLoadQueryInfluencers());
        Serializable[] idsInBatchArray = idsInBatch.toArray(new Serializable[idsInBatch.size()]);
        QueryParameters qp = DynamicBatchingEntityLoaderBuilder.buildMultiLoadQueryParameters(persister, idsInBatchArray, lockOptions);
        batchingLoader.doEntityBatchFetch(session, qp, idsInBatchArray);
        idsInBatch.clear();
    }

    protected List performUnorderedMultiLoad(OuterJoinLoadable persister, Serializable[] ids, SessionImplementor session, MultiLoadOptions loadOptions) {
        assert (!loadOptions.isOrderReturnEnabled());
        ArrayList result = CollectionHelper.arrayList(ids.length);
        if (loadOptions.isSessionCheckingEnabled()) {
            boolean foundAnyManagedEntities = false;
            ArrayList<Serializable> nonManagedIds = new ArrayList<Serializable>();
            for (Serializable id : ids) {
                EntityKey entityKey = new EntityKey(id, persister);
                Object managedEntity = session.getPersistenceContext().getEntity(entityKey);
                if (managedEntity != null) {
                    EntityEntry entry;
                    if (!loadOptions.isReturnOfDeletedEntitiesEnabled() && ((entry = session.getPersistenceContext().getEntry(managedEntity)).getStatus() == Status.DELETED || entry.getStatus() == Status.GONE)) continue;
                    foundAnyManagedEntities = true;
                    result.add(managedEntity);
                    continue;
                }
                nonManagedIds.add(id);
            }
            if (foundAnyManagedEntities) {
                if (nonManagedIds.isEmpty()) {
                    return result;
                }
                ids = nonManagedIds.toArray((Serializable[])Array.newInstance(ids.getClass().getComponentType(), nonManagedIds.size()));
            }
        }
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int numberOfIdsLeft = ids.length;
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getFactory().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(persister.getIdentifierType().getColumnSpan(session.getFactory()), numberOfIdsLeft);
        int idPosition = 0;
        while (numberOfIdsLeft > 0) {
            int batchSize = Math.min(numberOfIdsLeft, maxBatchSize);
            DynamicEntityLoader batchingLoader = new DynamicEntityLoader(persister, batchSize, lockOptions, session.getFactory(), session.getLoadQueryInfluencers());
            Serializable[] idsInBatch = new Serializable[batchSize];
            System.arraycopy(ids, idPosition, idsInBatch, 0, batchSize);
            QueryParameters qp = DynamicBatchingEntityLoaderBuilder.buildMultiLoadQueryParameters(persister, idsInBatch, lockOptions);
            result.addAll(batchingLoader.doEntityBatchFetch(session, qp, idsInBatch));
            numberOfIdsLeft -= batchSize;
            idPosition += batchSize;
        }
        return result;
    }

    public static QueryParameters buildMultiLoadQueryParameters(OuterJoinLoadable persister, Serializable[] ids, LockOptions lockOptions) {
        Object[] types = new Type[ids.length];
        Arrays.fill(types, persister.getIdentifierType());
        QueryParameters qp = new QueryParameters();
        qp.setOptionalEntityName(persister.getEntityName());
        qp.setPositionalParameterTypes((Type[])types);
        qp.setPositionalParameterValues(ids);
        qp.setLockOptions(lockOptions);
        qp.setOptionalObject(null);
        qp.setOptionalId(null);
        return qp;
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new DynamicBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new DynamicBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    private static class DynamicEntityLoader
    extends EntityLoader {
        private final String sqlTemplate;
        private final String alias;

        public DynamicEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            this(persister, maxBatchSize, lockOptions.getLockMode(), factory, loadQueryInfluencers);
        }

        public DynamicEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister, -1, lockMode, factory, loadQueryInfluencers);
            EntityJoinWalker walker = new EntityJoinWalker(persister, persister.getIdentifierColumnNames(), -1, lockMode, factory, loadQueryInfluencers){

                @Override
                protected StringBuilder whereString(String alias, String[] columnNames, int batchSize) {
                    return StringHelper.buildBatchFetchRestrictionFragment(alias, columnNames, this.getFactory().getDialect());
                }
            };
            this.initFromWalker(walker);
            this.sqlTemplate = walker.getSQLString();
            this.alias = walker.getAlias();
            this.postInstantiate();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("SQL-template for dynamic entity [%s] batch-fetching [%s] : %s", this.entityName, (Object)lockMode, this.sqlTemplate);
            }
        }

        @Override
        protected boolean isSingleRowLoader() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List doEntityBatchFetch(SessionImplementor session, QueryParameters queryParameters, Serializable[] ids) {
            String sql = StringHelper.expandBatchIdPlaceholder(this.sqlTemplate, ids, this.alias, this.persister.getKeyColumnNames(), this.getFactory().getDialect());
            PersistenceContext persistenceContext = session.getPersistenceContext();
            boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
            if (queryParameters.isReadOnlyInitialized()) {
                persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
            } else {
                queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
            }
            persistenceContext.beforeLoad();
            try {
                List results;
                try {
                    results = this.doTheLoad(sql, queryParameters, session);
                }
                finally {
                    persistenceContext.afterLoad();
                }
                persistenceContext.initializeNonLazyCollections();
                log.debug((Object)"Done batch load");
                List list = results;
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
                return list;
            }
            catch (Throwable throwable) {
                try {
                    persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
                    throw throwable;
                }
                catch (SQLException sqle) {
                    throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.getEntityPersisters()[0], ids, session.getFactory()), sql);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List doTheLoad(String sql, QueryParameters queryParameters, SessionImplementor session) throws SQLException {
            RowSelection selection = queryParameters.getRowSelection();
            int maxRows = LimitHelper.hasMaxRows(selection) ? selection.getMaxRows() : Integer.MAX_VALUE;
            ArrayList<AfterLoadAction> afterLoadActions = new ArrayList<AfterLoadAction>();
            Loader.SqlStatementWrapper wrapper = this.executeQueryStatement(sql, queryParameters, false, afterLoadActions, session);
            ResultSet rs = wrapper.getResultSet();
            Statement st = wrapper.getStatement();
            try {
                List list = this.processResultSet(rs, queryParameters, session, false, null, maxRows, afterLoadActions);
                return list;
            }
            finally {
                session.getJdbcCoordinator().getResourceRegistry().release(st);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
    }

    public static class DynamicBatchingEntityLoader
    extends BatchingEntityLoader {
        private final int maxBatchSize;
        private final UniqueEntityLoader singleKeyLoader;
        private final DynamicEntityLoader dynamicLoader;

        public DynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.maxBatchSize = maxBatchSize;
            this.singleKeyLoader = new EntityLoader(persister, 1, lockMode, factory, loadQueryInfluencers);
            this.dynamicLoader = new DynamicEntityLoader(persister, maxBatchSize, lockMode, factory, loadQueryInfluencers);
        }

        public DynamicBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.maxBatchSize = maxBatchSize;
            this.singleKeyLoader = new EntityLoader(persister, 1, lockOptions, factory, loadQueryInfluencers);
            this.dynamicLoader = new DynamicEntityLoader(persister, maxBatchSize, lockOptions, factory, loadQueryInfluencers);
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
            Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.maxBatchSize, this.persister().getEntityMode());
            int numberOfIds = ArrayHelper.countNonNull(batch);
            if (numberOfIds <= 1) {
                return this.singleKeyLoader.load(id, optionalObject, session);
            }
            Serializable[] idsToLoad = new Serializable[numberOfIds];
            System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
            if (log.isDebugEnabled()) {
                log.debugf("Batch loading entity: %s", (Object)MessageHelper.infoString(this.persister(), idsToLoad, session.getFactory()));
            }
            QueryParameters qp = this.buildQueryParameters(id, idsToLoad, optionalObject, lockOptions);
            List results = this.dynamicLoader.doEntityBatchFetch(session, qp, idsToLoad);
            return this.getObjectFromList(results, id, session);
        }
    }
}

