/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver;

import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.Configuration;
import org.wildfly.extension.nosql.driver.OrientInteraction;
import org.wildfly.extension.nosql.subsystem.orientdb.OrientSubsystemService;
import org.wildfly.nosql.common.NoSQLLogger;
import org.wildfly.nosql.common.spi.NoSQLConnection;

public class OrientClientConnectionsService
implements Service<OrientClientConnectionsService>,
NoSQLConnection {
    private Configuration configuration;
    private final OrientInteraction orientInteraction;
    private final InjectedValue<OrientSubsystemService> orientSubsystemServiceInjectedValue = new InjectedValue();
    private final InjectedValue<OutboundSocketBinding> outboundSocketBindingInjectedValue = new InjectedValue();
    private final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    private volatile Object databasePool;

    public OrientClientConnectionsService(Configuration configuration, OrientInteraction orientInteraction) {
        this.configuration = configuration;
        this.orientInteraction = orientInteraction;
    }

    public void start(StartContext startContext) throws StartException {
        this.initOrientSubsystemService();
        this.initDatabaseUrl();
        this.databasePool = this.orientInteraction.getDatabasePool();
    }

    public void stop(StopContext stopContext) {
        ((OrientSubsystemService)this.orientSubsystemServiceInjectedValue.getValue()).removeModuleNameFromJndi(this.configuration.getJndiName());
        ((OrientSubsystemService)this.orientSubsystemServiceInjectedValue.getValue()).removeModuleNameFromProfile(this.configuration.getProfileName());
        try {
            this.orientInteraction.close(this.databasePool);
        }
        catch (Throwable throwable) {
            NoSQLLogger.ROOT_LOGGER.driverFailedToStop(throwable);
        }
        finally {
            this.databasePool = null;
        }
    }

    public OrientClientConnectionsService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.orientInteraction.getDatabasePoolClass().isAssignableFrom(clazz)) {
            return (T)this.databasePool;
        }
        throw NoSQLLogger.ROOT_LOGGER.unassignable(clazz);
    }

    public InjectedValue<OrientSubsystemService> getOrientSubsystemServiceInjectedValue() {
        return this.orientSubsystemServiceInjectedValue;
    }

    public InjectedValue<OutboundSocketBinding> getOutboundSocketBindingInjectedValue() {
        return this.outboundSocketBindingInjectedValue;
    }

    public InjectedValue<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    private void initOrientSubsystemService() {
        ((OrientSubsystemService)this.orientSubsystemServiceInjectedValue.getValue()).addModuleNameFromJndi(this.configuration.getJndiName(), this.configuration.getModuleName());
        ((OrientSubsystemService)this.orientSubsystemServiceInjectedValue.getValue()).addModuleNameFromProfile(this.configuration.getProfileName(), this.configuration.getModuleName());
    }

    private void initDatabaseUrl() {
        Configuration.Builder configurationBuilder = new Configuration.Builder(this.configuration);
        configurationBuilder.databaseUrl(this.getDatabaseUrl((OutboundSocketBinding)this.outboundSocketBindingInjectedValue.getValue(), this.configuration));
        Configuration extraConfiguration = configurationBuilder.build();
        this.configuration.setDatabaseUrl(extraConfiguration.getDatabaseUrl());
        if (this.subjectFactory.getOptionalValue() != null) {
            this.orientInteraction.subjectFactory((SubjectFactory)this.subjectFactory.getOptionalValue());
        }
    }

    private String getDatabaseUrl(OutboundSocketBinding target, Configuration configuration) {
        String databaseUrl;
        if (target == null || target.getUnresolvedDestinationAddress() == null) {
            return configuration.getDatabase();
        }
        if (configuration.isRemote()) {
            databaseUrl = "remote:" + target.getUnresolvedDestinationAddress();
            if (target.getDestinationPort() > 0) {
                databaseUrl = databaseUrl + ":" + target.getDestinationPort();
            }
        } else {
            databaseUrl = "plocal:";
        }
        String result = databaseUrl + "/" + configuration.getDatabase();
        NoSQLLogger.ROOT_LOGGER.tracef("Database URL '%s'", (Object)result);
        return result;
    }
}

