/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.wildfly.plugin.tests.TestEnvironment;

@RunWith(value=JUnit4.class)
public abstract class AbstractProvisionConfiguredMojoTestCase
extends AbstractMojoTestCase {
    private static final String TEST_REPLACE_WF_VERSION = "WF_VERSION";
    static final String WILDFLY_VERSION = "wildfly.test.version";
    private final String artifactId;

    protected AbstractProvisionConfiguredMojoTestCase(String artifactId) {
        this.artifactId = artifactId;
    }

    protected MavenSession newMavenSession() {
        try {
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)this.getContainer().lookup(MavenExecutionRequestPopulator.class);
            populator.populateDefaults((MavenExecutionRequest)request);
            DefaultMaven maven = (DefaultMaven)this.getContainer().lookup(Maven.class);
            DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)maven.newRepositorySession((MavenExecutionRequest)request);
            ArtifactRepositoryPolicy snapshot = new ArtifactRepositoryPolicy(false, "never", "ignore");
            ArtifactRepositoryPolicy release = new ArtifactRepositoryPolicy(true, "daily", "ignore");
            String path = System.getProperty("maven.repo.local", request.getLocalRepository().getBasedir());
            repoSession.setLocalRepositoryManager(new SimpleLocalRepositoryManagerFactory().newInstance((RepositorySystemSession)repoSession, new LocalRepository(path)));
            request.addRemoteRepository((ArtifactRepository)new MavenArtifactRepository("jboss", "https://repository.jboss.org/nexus/content/groups/public/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshot, release));
            request.addRemoteRepository((ArtifactRepository)new MavenArtifactRepository("redhat-ga", "https://maven.repository.redhat.com/ga/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshot, release));
            MavenSession session = new MavenSession(this.getContainer(), (RepositorySystemSession)repoSession, (MavenExecutionRequest)request, (MavenExecutionResult)result);
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MavenSession newMavenSession(MavenProject project) {
        MavenSession session = this.newMavenSession();
        session.setCurrentProject(project);
        session.setProjects(Arrays.asList(project));
        return session;
    }

    protected Mojo lookupConfiguredMojo(File pom, String goal) throws Exception {
        AbstractProvisionConfiguredMojoTestCase.assertNotNull((Object)pom);
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)pom.exists());
        this.patchPomFile(pom);
        ProjectBuildingRequest buildingRequest = this.newMavenSession().getProjectBuildingRequest();
        buildingRequest.setResolveDependencies(true);
        ProjectBuilder projectBuilder = (ProjectBuilder)this.lookup(ProjectBuilder.class);
        MavenProject project = projectBuilder.build(pom, buildingRequest).getProject();
        Mojo mojo = this.lookupConfiguredMojo(project, goal);
        this.configureMojo(mojo, this.artifactId, pom);
        return mojo;
    }

    private void patchPomFile(File pom) throws IOException {
        StringBuilder content = new StringBuilder();
        for (String s : Files.readAllLines(pom.toPath())) {
            if (s.contains(TEST_REPLACE_WF_VERSION)) {
                s = s.replace(TEST_REPLACE_WF_VERSION, System.getProperty(WILDFLY_VERSION));
            }
            content.append(s).append(System.lineSeparator());
        }
        Files.write(pom.toPath(), content.toString().getBytes(), new OpenOption[0]);
    }

    @Before
    public void before() throws Exception {
        super.setUp();
    }

    public void checkStandaloneWildFlyHome(Path wildflyHome, int numDeployments, String[] layers, String[] excludedLayers, boolean stateRecorded, String ... configTokens) throws Exception {
        String[] deployments;
        Path rootDir;
        Assert.assertTrue((boolean)TestEnvironment.isValidWildFlyHome(wildflyHome));
        if (numDeployments > 0) {
            rootDir = wildflyHome.resolve("standalone/deployments");
            deployments = rootDir.toFile().list((dir, name) -> !name.equals("README.txt"));
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)numDeployments, (int)deployments.length);
        } else {
            rootDir = wildflyHome.resolve("standalone/deployments");
            deployments = rootDir.toFile().list((dir, name) -> !name.equals("README.txt"));
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)0, (int)deployments.length);
        }
        Path history = wildflyHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(history, new LinkOption[0]));
        Path configFile = wildflyHome.resolve("standalone/configuration/standalone.xml");
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(configFile, new LinkOption[0]));
        if (layers != null) {
            Path provisioning = PathsUtils.getProvisioningXml((Path)wildflyHome);
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(provisioning, new LinkOption[0]));
            ProvisioningConfig config = ProvisioningXmlParser.parse((Path)provisioning);
            ConfigModel cm = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
            AbstractProvisionConfiguredMojoTestCase.assertNotNull((String)config.getDefinedConfigs().toString(), (Object)cm);
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)layers.length, (int)cm.getIncludedLayers().size());
            for (String layer : layers) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)cm.getIncludedLayers().contains(layer));
            }
            if (excludedLayers != null) {
                for (String layer : excludedLayers) {
                    AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)cm.getExcludedLayers().contains(layer));
                }
            }
        }
        if (configTokens != null) {
            String str = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
            for (String token : configTokens) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((String)str, (boolean)str.contains(token));
            }
        }
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".galleon"), new LinkOption[0]), (boolean)stateRecorded);
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".wildfly-maven-plugin-provisioning.xml"), new LinkOption[0]), (!stateRecorded ? 1 : 0) != 0);
    }

    public void checkDomainWildFlyHome(Path wildflyHome, int numDeployments, boolean stateRecorded, String ... configTokens) throws Exception {
        Assert.assertTrue((boolean)TestEnvironment.isValidWildFlyHome(wildflyHome));
        if (numDeployments > 0) {
            Path rootDir = wildflyHome.resolve("domain/data/content");
            final ArrayList deployments = new ArrayList();
            Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if ("content".equals(file.getFileName().toString())) {
                        deployments.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)numDeployments, (int)deployments.size());
        } else if (Files.exists(wildflyHome.resolve("domain/data/content"), new LinkOption[0])) {
            AbstractProvisionConfiguredMojoTestCase.assertEquals((long)0L, (long)Files.list(wildflyHome.resolve("domain/data/content")).count());
        }
        Path history = wildflyHome.resolve("domain").resolve("configuration").resolve("domain_xml_history");
        AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(history, new LinkOption[0]));
        Path configFile = wildflyHome.resolve("domain/configuration/domain.xml");
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(configFile, new LinkOption[0]));
        if (configTokens != null) {
            String str = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
            for (String token : configTokens) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((String)str, (boolean)str.contains(token));
            }
        }
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".galleon"), new LinkOption[0]), (boolean)stateRecorded);
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".wildfly-maven-plugin-provisioning.xml"), new LinkOption[0]), (!stateRecorded ? 1 : 0) != 0);
    }
}

