/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.MojoRule;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.jboss.galleon.util.PropertyUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.wildfly.plugin.tests.TestEnvironment;
import org.wildfly.plugin.tools.Deployment;

public abstract class AbstractWildFlyMojoTest {
    protected final String DEPLOYMENT_NAME = "test.war";
    protected static final String BASE_CONFIG_DIR = System.getProperty("wildfly.test.config.dir");
    @Rule
    public MojoRule rule = new MojoRule(){

        protected void before() throws Throwable {
        }

        protected void after() {
        }
    };

    protected Deployment getDeployment() {
        return Deployment.of((Path)Paths.get(BASE_CONFIG_DIR, "target", "test.war"));
    }

    public <T extends Mojo> T lookupMojoAndVerify(String goal, String fileName) throws Exception {
        Path pom = AbstractWildFlyMojoTest.getPomFile(fileName);
        MavenProject project = this.readMavenProject(pom);
        Mojo mojo = this.rule.lookupConfiguredMojo(project, goal);
        Assert.assertNotNull((Object)mojo);
        AbstractWildFlyMojoTest.setDefaultEnvironment(mojo);
        return (T)mojo;
    }

    public static Path getPomFile(String fileName) {
        Path baseDir = AbstractWildFlyMojoTest.getBaseDir();
        Path pom = baseDir.resolve(fileName);
        Assert.assertTrue((boolean)Files.exists(pom, new LinkOption[0]));
        return pom;
    }

    public static Path getBaseDir() {
        Path baseDir = Paths.get(BASE_CONFIG_DIR, new String[0]);
        Assert.assertTrue((String)("Not a directory: " + BASE_CONFIG_DIR), (boolean)Files.exists(baseDir, new LinkOption[0]));
        return baseDir;
    }

    public MavenProject readMavenProject(Path pom) throws Exception {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setBaseDirectory(pom.getParent().toFile());
        ProjectBuildingRequest configuration = request.getProjectBuildingRequest();
        configuration.setRepositorySession((RepositorySystemSession)new DefaultRepositorySystemSession());
        MavenProject project = ((ProjectBuilder)this.rule.lookup(ProjectBuilder.class)).build(pom.toFile(), configuration).getProject();
        Assert.assertNotNull((Object)project);
        return project;
    }

    protected static void setDefaultEnvironment(Mojo instance) throws NoSuchFieldException, IllegalAccessException {
        AbstractWildFlyMojoTest.setValue(instance, "port", (Object)TestEnvironment.PORT);
        AbstractWildFlyMojoTest.setValue(instance, "hostname", (Object)TestEnvironment.HOSTNAME);
    }

    protected static void setValue(Object instance, String name, Object value) throws NoSuchFieldException, IllegalAccessException {
        AbstractWildFlyMojoTest.setValue(instance.getClass(), instance, name, value);
    }

    private static void setValue(Class<?> clazz, Object instance, String name, Object value) throws NoSuchFieldException, IllegalAccessException {
        if (clazz == null || Object.class.getName().equals(clazz.getName())) {
            throw new NoSuchFieldException("Field " + name + " not found on " + instance.getClass().getName());
        }
        try {
            Field field = clazz.getDeclaredField(name);
            AbstractWildFlyMojoTest.setValue(field, instance, value);
        }
        catch (NoSuchFieldException e) {
            AbstractWildFlyMojoTest.setValue(clazz.getSuperclass(), instance, name, value);
        }
    }

    private static void setValue(Field field, Object instance, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(instance, value);
    }

    private static Path getDefaultMavenRepositoryPath() {
        String repoPath = PropertyUtils.getSystemProperty((String)"maven.repo.path");
        if (repoPath == null) {
            repoPath = PropertyUtils.getSystemProperty((String)"user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";
        }
        return Paths.get(repoPath, new String[0]);
    }

    protected static void setValidSession(Mojo mojo) throws NoLocalRepositoryManagerException, NoSuchFieldException, IllegalAccessException {
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession();
        String path = System.getProperty("maven.repo.local", AbstractWildFlyMojoTest.getDefaultMavenRepositoryPath().toString());
        repoSession.setLocalRepositoryManager(new SimpleLocalRepositoryManagerFactory().newInstance((RepositorySystemSession)repoSession, new LocalRepository(path)));
        AbstractWildFlyMojoTest.setValue(mojo, "session", (Object)repoSession);
    }
}

