/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.tests.TestEnvironment;
import org.wildfly.plugin.tools.ServerHelper;

@RunWith(value=JUnit4.class)
public abstract class AbstractProvisionConfiguredMojoTestCase
extends AbstractMojoTestCase {
    private static final String TEST_REPLACE_WF_VERSION = "WF_VERSION";
    static final String WILDFLY_VERSION = "wildfly.test.version";
    private final String artifactId;

    protected AbstractProvisionConfiguredMojoTestCase(String artifactId) {
        this.artifactId = artifactId;
    }

    protected MavenSession newMavenSession() {
        try {
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)this.getContainer().lookup(MavenExecutionRequestPopulator.class);
            populator.populateDefaults((MavenExecutionRequest)request);
            DefaultMaven maven = (DefaultMaven)this.getContainer().lookup(Maven.class);
            DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)maven.newRepositorySession((MavenExecutionRequest)request);
            ArtifactRepositoryPolicy snapshot = new ArtifactRepositoryPolicy(false, "never", "ignore");
            ArtifactRepositoryPolicy release = new ArtifactRepositoryPolicy(true, "daily", "ignore");
            String path = System.getProperty("maven.repo.local", request.getLocalRepository().getBasedir());
            repoSession.setLocalRepositoryManager(new SimpleLocalRepositoryManagerFactory().newInstance((RepositorySystemSession)repoSession, new LocalRepository(path)));
            request.addRemoteRepository((ArtifactRepository)new MavenArtifactRepository("jboss", "https://repository.jboss.org/nexus/content/groups/public/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshot, release));
            request.addRemoteRepository((ArtifactRepository)new MavenArtifactRepository("redhat-ga", "https://maven.repository.redhat.com/ga/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshot, release));
            MavenSession session = new MavenSession(this.getContainer(), (RepositorySystemSession)repoSession, (MavenExecutionRequest)request, (MavenExecutionResult)result);
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MavenSession newMavenSession(MavenProject project) {
        MavenSession session = this.newMavenSession();
        session.setCurrentProject(project);
        session.setProjects(Arrays.asList(project));
        return session;
    }

    protected Mojo lookupConfiguredMojo(File pom, String goal) throws Exception {
        return this.lookupConfiguredMojo(pom.toPath(), goal);
    }

    protected Mojo lookupConfiguredMojo(Path pom, String goal) throws Exception {
        AbstractProvisionConfiguredMojoTestCase.assertNotNull((Object)pom);
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(pom, new LinkOption[0]));
        this.patchPomFile(pom);
        ProjectBuildingRequest buildingRequest = this.newMavenSession().getProjectBuildingRequest();
        buildingRequest.setResolveDependencies(true);
        ProjectBuilder projectBuilder = (ProjectBuilder)this.lookup(ProjectBuilder.class);
        MavenProject project = projectBuilder.build(pom.toFile(), buildingRequest).getProject();
        Mojo mojo = this.lookupConfiguredMojo(project, goal);
        this.configureMojo(mojo, this.artifactId, pom.toFile());
        return mojo;
    }

    private void patchPomFile(Path pom) throws IOException {
        StringBuilder content = new StringBuilder();
        for (String s : Files.readAllLines(pom)) {
            if (s.contains(TEST_REPLACE_WF_VERSION)) {
                s = s.replace(TEST_REPLACE_WF_VERSION, System.getProperty(WILDFLY_VERSION));
            }
            content.append(s).append(System.lineSeparator());
        }
        Files.write(pom, content.toString().getBytes(), new OpenOption[0]);
    }

    @Before
    public void before() throws Exception {
        super.setUp();
    }

    public void checkStandaloneWildFlyHome(Path wildflyHome, int numDeployments, String[] layers, String[] excludedLayers, boolean stateRecorded, String ... configTokens) throws Exception {
        String[] deployments;
        Path rootDir;
        Assert.assertTrue((boolean)TestEnvironment.isValidWildFlyHome(wildflyHome));
        if (numDeployments > 0) {
            rootDir = wildflyHome.resolve("standalone/deployments");
            deployments = rootDir.toFile().list((dir, name) -> !name.equals("README.txt"));
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)numDeployments, (int)deployments.length);
        } else {
            rootDir = wildflyHome.resolve("standalone/deployments");
            deployments = rootDir.toFile().list((dir, name) -> !name.equals("README.txt"));
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)0, (int)deployments.length);
        }
        Path history = wildflyHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(history, new LinkOption[0]));
        Path configFile = wildflyHome.resolve("standalone/configuration/standalone.xml");
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(configFile, new LinkOption[0]));
        if (layers != null) {
            Path provisioning = PathsUtils.getProvisioningXml((Path)wildflyHome);
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(provisioning, new LinkOption[0]));
            ProvisioningConfig config = ProvisioningXmlParser.parse((Path)provisioning);
            ConfigModel cm = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
            AbstractProvisionConfiguredMojoTestCase.assertNotNull((String)config.getDefinedConfigs().toString(), (Object)cm);
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)layers.length, (int)cm.getIncludedLayers().size());
            for (String layer : layers) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)cm.getIncludedLayers().contains(layer));
            }
            if (excludedLayers != null) {
                for (String layer : excludedLayers) {
                    AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)cm.getExcludedLayers().contains(layer));
                }
            }
        }
        if (configTokens != null) {
            String str = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
            for (String token : configTokens) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((String)str, (boolean)str.contains(token));
            }
        }
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".galleon"), new LinkOption[0]), (boolean)stateRecorded);
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".wildfly-maven-plugin-provisioning.xml"), new LinkOption[0]), (!stateRecorded ? 1 : 0) != 0);
    }

    public void checkDomainWildFlyHome(Path wildflyHome, int numDeployments, boolean stateRecorded, String ... configTokens) throws Exception {
        Assert.assertTrue((boolean)TestEnvironment.isValidWildFlyHome(wildflyHome));
        if (numDeployments > 0) {
            Path rootDir = wildflyHome.resolve("domain/data/content");
            final ArrayList deployments = new ArrayList();
            Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if ("content".equals(file.getFileName().toString())) {
                        deployments.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            AbstractProvisionConfiguredMojoTestCase.assertEquals((int)numDeployments, (int)deployments.size());
        } else if (Files.exists(wildflyHome.resolve("domain/data/content"), new LinkOption[0])) {
            AbstractProvisionConfiguredMojoTestCase.assertEquals((long)0L, (long)Files.list(wildflyHome.resolve("domain/data/content")).count());
        }
        Path history = wildflyHome.resolve("domain").resolve("configuration").resolve("domain_xml_history");
        AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(history, new LinkOption[0]));
        Path configFile = wildflyHome.resolve("domain/configuration/domain.xml");
        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(configFile, new LinkOption[0]));
        if (configTokens != null) {
            String str = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
            for (String token : configTokens) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((String)str, (boolean)str.contains(token));
            }
        }
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".galleon"), new LinkOption[0]), (boolean)stateRecorded);
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".wildfly-maven-plugin-provisioning.xml"), new LinkOption[0]), (!stateRecorded ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkJar(Path dir, String fileName, String deploymentName, boolean expectDeployment, String[] layers, String[] excludedLayers, boolean stateRecorded, String ... configTokens) throws Exception {
        Path wildflyHome = null;
        try {
            wildflyHome = this.checkAndGetWildFlyHome(dir, fileName, deploymentName, expectDeployment, layers, excludedLayers, stateRecorded, configTokens);
            if (wildflyHome == null) return;
        }
        catch (Throwable throwable) {
            if (wildflyHome == null) throw throwable;
            IoUtils.recursiveDelete(wildflyHome);
            throw throwable;
        }
        IoUtils.recursiveDelete((Path)wildflyHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path checkAndGetWildFlyHome(Path dir, String fileName, String deploymentName, boolean expectDeployment, String[] layers, String[] excludedLayers, boolean stateRecorded, String ... configTokens) throws Exception {
        Path tmpDir = Files.createTempDirectory("bootable-jar-test-unzipped", new FileAttribute[0]);
        Path wildflyHome = Files.createTempDirectory("bootable-jar-test-unzipped-bootable", new FileAttribute[0]);
        try {
            Path jar = dir.resolve("target").resolve(fileName == null ? "server-bootable.jar" : fileName);
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(jar, new LinkOption[0]));
            ZipUtils.unzip((Path)jar, (Path)tmpDir);
            Path zippedWildfly = tmpDir.resolve("wildfly.zip");
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(zippedWildfly, new LinkOption[0]));
            Path provisioningFile = tmpDir.resolve("provisioning.xml");
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(provisioningFile, new LinkOption[0]));
            ZipUtils.unzip((Path)zippedWildfly, (Path)wildflyHome);
            if (expectDeployment) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(wildflyHome.resolve("standalone/deployments").resolve(deploymentName), new LinkOption[0]));
            } else {
                AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(wildflyHome.resolve("standalone/deployments").resolve(deploymentName), new LinkOption[0]));
            }
            Path history = wildflyHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
            AbstractProvisionConfiguredMojoTestCase.assertFalse((boolean)Files.exists(history, new LinkOption[0]));
            Path configFile = wildflyHome.resolve("standalone/configuration/standalone.xml");
            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(configFile, new LinkOption[0]));
            if (layers != null) {
                Path pFile = PathsUtils.getProvisioningXml((Path)wildflyHome);
                AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)Files.exists(pFile, new LinkOption[0]));
                try (Provisioning provisioning = new GalleonBuilder().newProvisioningBuilder(pFile).build();){
                    GalleonProvisioningConfig configDescription = provisioning.loadProvisioningConfig(pFile);
                    GalleonConfigurationWithLayers config = null;
                    for (GalleonConfigurationWithLayers c : configDescription.getDefinedConfigs()) {
                        if (!c.getModel().equals("standalone") || !c.getName().equals("standalone.xml")) continue;
                        config = c;
                    }
                    AbstractProvisionConfiguredMojoTestCase.assertNotNull(config);
                    AbstractProvisionConfiguredMojoTestCase.assertEquals((int)layers.length, (int)config.getIncludedLayers().size());
                    for (String layer : layers) {
                        AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)config.getIncludedLayers().contains(layer));
                    }
                    if (excludedLayers != null) {
                        for (String layer : excludedLayers) {
                            AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)config.getExcludedLayers().contains(layer));
                        }
                    }
                }
            }
            if (configTokens != null) {
                String str = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
                for (String token : configTokens) {
                    AbstractProvisionConfiguredMojoTestCase.assertTrue((String)str, (boolean)str.contains(token));
                }
            }
        }
        finally {
            IoUtils.recursiveDelete((Path)tmpDir);
        }
        AbstractProvisionConfiguredMojoTestCase.assertEquals((boolean)Files.exists(wildflyHome.resolve(".galleon"), new LinkOption[0]), (boolean)stateRecorded);
        return wildflyHome;
    }

    protected void checkDeployment(Path dir, String fileName, String deploymentName) throws Exception {
        this.checkURL(dir, fileName, AbstractProvisionConfiguredMojoTestCase.createUrl(TestEnvironment.HTTP_PORT, deploymentName == null ? "" : deploymentName), true, new String[0]);
    }

    protected static String createUrl(int port, String ... paths) {
        StringBuilder result = new StringBuilder(32).append("http://").append(TestEnvironment.HOSTNAME).append(':').append(port);
        for (String path : paths) {
            result.append('/').append(path);
        }
        return result.toString();
    }

    protected boolean checkURL(String url) {
        boolean bl;
        block8: {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            try {
                HttpGet httpget = new HttpGet(url);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                System.out.println("STATUS CODE " + response.getStatusLine().getStatusCode());
                boolean bl2 = bl = response.getStatusLine().getStatusCode() == 200;
                if (httpclient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpclient != null) {
                        try {
                            httpclient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    return false;
                }
            }
            httpclient.close();
        }
        return bl;
    }

    private static void shutdown() throws IOException {
        try (ModelControllerClient client = ModelControllerClient.Factory.create((String)TestEnvironment.HOSTNAME, (int)TestEnvironment.PORT);){
            if (ServerHelper.isStandaloneRunning((ModelControllerClient)client)) {
                ServerHelper.shutdownStandalone((ModelControllerClient)client, (int)((int)TestEnvironment.TIMEOUT));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkURL(Path dir, String fileName, String url, boolean start, String ... args) throws Exception {
        Process process = null;
        int timeout = (int)TestEnvironment.TIMEOUT * 1000;
        long sleep = 1000L;
        boolean success = false;
        try {
            if (start) {
                process = this.startServer(dir, fileName, args);
            }
            try (ModelControllerClient client = ModelControllerClient.Factory.create((String)TestEnvironment.HOSTNAME, (int)TestEnvironment.PORT);){
                ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)TestEnvironment.TIMEOUT);
            }
            if (url == null) {
                success = true;
            } else {
                while (timeout > 0) {
                    if (this.checkURL(url)) {
                        System.out.println("Successfully connected to " + url);
                        success = true;
                        break;
                    }
                    Thread.sleep(sleep);
                    timeout = (int)((long)timeout - sleep);
                }
            }
            if (process != null) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((boolean)process.isAlive());
            }
            AbstractProvisionConfiguredMojoTestCase.shutdown();
            if (process != null) {
                AbstractProvisionConfiguredMojoTestCase.assertTrue((String)"The process has failed to shutdown", (boolean)process.waitFor(TestEnvironment.TIMEOUT, TimeUnit.SECONDS));
            }
        }
        catch (Throwable throwable) {
            ProcessHelper.destroyProcess(process);
            throw throwable;
        }
        ProcessHelper.destroyProcess((Process)process);
        if (!success) {
            throw new Exception("Unable to interact with deployed application");
        }
    }

    protected Process startServer(Path dir, String fileName, String ... args) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(TestEnvironment.getJavaCommand(null));
        cmd.add("-jar");
        cmd.add(dir.resolve("target").resolve(fileName).toAbsolutePath().toString());
        cmd.add("-Djboss.management.http.port=" + TestEnvironment.PORT);
        cmd.add("-Djboss.http.port=" + TestEnvironment.HTTP_PORT);
        cmd.addAll(Arrays.asList(args));
        Path out = Files.createTempFile("logs-package-bootable", "-process.txt", new FileAttribute[0]);
        Path parent = out.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return new ProcessBuilder(cmd).redirectErrorStream(true).redirectOutput(out.toFile()).start();
    }
}

