/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.wildfly.plugin.common.Environment;

public class TestEnvironment
extends Environment {
    public static final Path WILDFLY_HOME;
    public static final String HOSTNAME;
    public static final int PORT;
    public static final int HTTP_PORT;
    public static final long TIMEOUT;
    private static final boolean IS_MODULAR_JVM;

    public static boolean isModularJvm() {
        return IS_MODULAR_JVM;
    }

    public static boolean isValidWildFlyHome(Path wildflyHome) {
        return Files.exists(wildflyHome, new LinkOption[0]) && Files.isDirectory(wildflyHome, new LinkOption[0]) && Files.exists(wildflyHome.resolve("jboss-modules.jar"), new LinkOption[0]);
    }

    public static void validateWildFlyHome(Path wildflyHome) {
        if (!TestEnvironment.isValidWildFlyHome(wildflyHome)) {
            throw new RuntimeException("Invalid WildFly home directory: " + wildflyHome);
        }
    }

    static {
        int vmVersion;
        HOSTNAME = System.getProperty("wildfly.management.hostname", "localhost");
        Logger logger = Logger.getLogger(TestEnvironment.class);
        Path wildflyHome = null;
        if (!Boolean.getBoolean("wildfly.test.bootable")) {
            String wildflyDist = System.getProperty("jboss.home");
            assert (wildflyDist != null) : "WildFly home property, jboss.home, was not set";
            wildflyHome = Paths.get(wildflyDist, new String[0]);
            TestEnvironment.validateWildFlyHome(wildflyHome);
        }
        WILDFLY_HOME = wildflyHome;
        String port = System.getProperty("wildfly.management.port", "9990");
        try {
            PORT = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            logger.debugf((Throwable)e, "Invalid port: %s", (Object)port);
            throw new RuntimeException("Invalid port: " + port, e);
        }
        String httpPort = System.getProperty("wildfly.http.port", "8080");
        try {
            HTTP_PORT = Integer.parseInt(httpPort);
        }
        catch (NumberFormatException e) {
            logger.debugf((Throwable)e, "Invalid port: %s", (Object)port);
            throw new RuntimeException("Invalid port: " + port, e);
        }
        String timeout = System.getProperty("wildfly.timeout", "60");
        try {
            TIMEOUT = Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            logger.debugf((Throwable)e, "Invalid timeout: %s", (Object)timeout);
            throw new RuntimeException("Invalid timeout: " + timeout, e);
        }
        String javaVersion = System.getProperty("java.specification.version");
        try {
            Matcher matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(javaVersion);
            if (!matcher.find()) {
                throw new RuntimeException("Unknown version of jvm " + javaVersion);
            }
            vmVersion = Integer.valueOf(matcher.group(1));
        }
        catch (Exception e) {
            vmVersion = 8;
        }
        IS_MODULAR_JVM = vmVersion > 8;
    }
}

