/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tests;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.inject.Inject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.wildfly.plugin.tests.AbstractWildFlyMojoTest;
import org.wildfly.plugin.tests.runner.WildFlyTestRunner;

@RunWith(value=WildFlyTestRunner.class)
public abstract class AbstractWildFlyServerMojoTest
extends AbstractWildFlyMojoTest {
    @Inject
    protected ModelControllerClient client;

    protected ModelNode executeOperation(ModelNode op) throws IOException {
        ModelNode result = this.client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            Assert.fail((String)Operations.getFailureDescription((ModelNode)result).asString());
        }
        return result;
    }

    protected static void deleteRecursively(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                Files.deleteIfExists(path);
            }
        }
    }
}

