/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.resource;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.cli.Commands;

public class Resource {
    @Parameter
    private String address;
    @Parameter
    private boolean addIfAbsent;
    @Parameter
    private Map<String, String> properties;
    @Parameter(alias="before-add")
    private Commands beforeAdd;
    @Parameter(alias="after-add")
    private Commands afterAdd;
    @Parameter(defaultValue="false", property="add-resource.enableResource")
    private boolean enableResource;
    @Parameter
    private Resource[] resources;

    public Resource() {
    }

    Resource(String address, Map<String, String> properties, boolean enableResource) {
        this.address = address;
        this.properties = properties;
        this.enableResource = enableResource;
        this.addIfAbsent = false;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isAddIfAbsent() {
        return this.addIfAbsent;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public boolean isEnableResource() {
        return this.enableResource;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public boolean hasBeforeAddCommands() {
        return this.beforeAdd != null && this.beforeAdd.hasCommands();
    }

    public Commands getBeforeAdd() {
        return this.beforeAdd;
    }

    public boolean hasAfterAddCommands() {
        return this.afterAdd != null && this.afterAdd.hasCommands();
    }

    public Commands getAfterAdd() {
        return this.afterAdd;
    }
}

