/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.server.ServerHelper;

abstract class Server {
    private final ScheduledExecutorService timerService;
    private final CommandBuilder commandBuilder;
    private final OutputStream stdout;
    private volatile Thread shutdownHook;
    private Process process;

    private Server(CommandBuilder commandBuilder, OutputStream stdout) {
        this.commandBuilder = commandBuilder;
        this.timerService = Executors.newScheduledThreadPool(1);
        this.stdout = stdout;
    }

    static Server create(CommandBuilder commandBuilder, ModelControllerClient client) {
        return Server.create(commandBuilder, client, null);
    }

    static Server create(CommandBuilder commandBuilder, final ModelControllerClient client, OutputStream stdout) {
        if (commandBuilder instanceof DomainCommandBuilder) {
            return new Server(commandBuilder, stdout){
                final DomainClient domainClient;
                final Map<ServerIdentity, ServerStatus> servers;
                volatile boolean isRunning;
                {
                    super(x0, x1);
                    this.domainClient = DomainClient.Factory.create((ModelControllerClient)client);
                    this.servers = new HashMap<ServerIdentity, ServerStatus>();
                    this.isRunning = false;
                }

                @Override
                protected void stopServer() {
                    ServerHelper.shutdownDomain(this.domainClient, this.servers);
                    if (this.domainClient != null) {
                        try {
                            this.domainClient.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }

                @Override
                protected boolean waitForStart(long timeout) throws IOException, InterruptedException {
                    return ServerHelper.waitForDomain(((Server)this).process, this.domainClient, this.servers, timeout);
                }

                @Override
                public boolean isRunning() {
                    return this.isRunning;
                }

                @Override
                protected void checkServerState() {
                    this.isRunning = ServerHelper.isDomainRunning(this.domainClient, this.servers);
                }
            };
        }
        return new Server(commandBuilder, stdout){
            volatile boolean isRunning;
            {
                super(x0, x1);
                this.isRunning = false;
            }

            @Override
            protected void stopServer() {
                ServerHelper.shutdownStandalone(client);
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected boolean waitForStart(long timeout) throws IOException, InterruptedException {
                return ServerHelper.waitForStandalone(((Server)this).process, client, timeout);
            }

            @Override
            public boolean isRunning() {
                return this.isRunning;
            }

            @Override
            protected void checkServerState() {
                this.isRunning = ServerHelper.isStandaloneRunning(client);
            }
        };
    }

    public final synchronized void start(long timeout) throws IOException, InterruptedException {
        Launcher launcher = Launcher.of((CommandBuilder)this.commandBuilder);
        if (this.stdout == null) {
            launcher.inherit();
        } else {
            launcher.setRedirectErrorStream(true);
        }
        this.process = launcher.launch();
        if (this.stdout != null) {
            new Thread(new ConsoleConsumer(this.process.getInputStream(), this.stdout)).start();
        }
        this.shutdownHook = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return ProcessHelper.addShutdownHook((Process)Server.this.process);
            }
        });
        if (!this.waitForStart(timeout)) {
            try {
                ProcessHelper.destroyProcess((Process)this.process);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            throw new IllegalStateException(String.format("Managed server was not started within [%d] s", timeout));
        }
        this.timerService.scheduleWithFixedDelay(new Reaper(), 20L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Runtime.getRuntime().removeShutdownHook(Server.this.shutdownHook);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
            try {
                this.timerService.shutdown();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.stopServer();
        }
        finally {
            try {
                ProcessHelper.destroyProcess((Process)this.process);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void stopServer();

    protected abstract boolean waitForStart(long var1) throws IOException, InterruptedException;

    public abstract boolean isRunning();

    protected abstract void checkServerState();

    static class ConsoleConsumer
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        ConsoleConsumer(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[64];
            try {
                int len;
                while ((len = this.in.read(buffer)) != -1) {
                    this.out.write(buffer, 0, len);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        @Override
        public void run() {
            Server.this.checkServerState();
            if (!Server.this.isRunning()) {
                Server.this.stop();
            }
        }
    }
}

