/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.ManagementClient;
import org.wildfly.plugin.common.ServerOperations;

@Mojo(name="shutdown")
public class ShutdownMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.reload")
    private boolean reload;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping server shutdown");
            return;
        }
        try (ManagementClient client = this.createClient();){
            if (this.reload) {
                client.execute(ServerOperations.createOperation((String)"reload"));
            } else {
                client.execute(ServerOperations.createOperation((String)"shutdown"));
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException ignore) {
                ignore.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    @Override
    public String goal() {
        return "shutdown";
    }
}

