/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class Commands {
    @Parameter
    private boolean batch;
    @Parameter
    private List<String> commands = new ArrayList<String>();
    @Parameter
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true")
    private boolean failOnError = true;

    public boolean isBatch() {
        return this.batch;
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    protected Collection<String> getCommands() {
        if (this.hasCommands()) {
            return new ArrayList<String>(this.commands);
        }
        return Collections.emptyList();
    }

    protected Collection<File> getScripts() {
        if (this.hasScripts()) {
            return new ArrayList<File>(this.scripts);
        }
        return Collections.emptyList();
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean hasScripts() {
        return this.scripts != null && !this.scripts.isEmpty();
    }
}

