/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.deployment.MatchPatternStrategy;
import org.wildfly.plugin.deployment.MavenDeployment;

public class DeploymentBuilder {
    protected final ModelControllerClient client;
    private final Set<String> serverGroups;
    private File content;
    private String name;
    private String runtimeName;
    private MavenDeployment.Type type;
    private String matchPattern;
    private MatchPatternStrategy matchPatternStrategy;

    private DeploymentBuilder(ModelControllerClient client, Collection<String> serverGroups) {
        if (client == null) {
            throw new IllegalArgumentException("The client must be set to communicate with the server.");
        }
        this.client = client;
        this.serverGroups = new LinkedHashSet<String>();
        if (serverGroups != null) {
            this.serverGroups.addAll(serverGroups);
        }
    }

    public static DeploymentBuilder of(ModelControllerClient client) {
        return new DeploymentBuilder(client, null);
    }

    public static DeploymentBuilder of(ModelControllerClient client, Collection<String> serverGroups) {
        return new DeploymentBuilder(client, serverGroups);
    }

    public MavenDeployment build() {
        this.validate();
        return new MavenDeployment(this.client, this.serverGroups, this.content, this.name, this.runtimeName, this.type, this.matchPattern, this.matchPatternStrategy);
    }

    public DeploymentBuilder setContent(File content) {
        this.content = content;
        return this;
    }

    public DeploymentBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public DeploymentBuilder setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
        return this;
    }

    public DeploymentBuilder setType(MavenDeployment.Type type) {
        this.type = type;
        return this;
    }

    public DeploymentBuilder setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
        return this;
    }

    public DeploymentBuilder setMatchPatternStrategy(MatchPatternStrategy matchPatternStrategy) {
        this.matchPatternStrategy = matchPatternStrategy;
        return this;
    }

    private void validate() {
        if (this.type != MavenDeployment.Type.UNDEPLOY && this.type != MavenDeployment.Type.UNDEPLOY_IGNORE_MISSING && this.content == null) {
            throw new IllegalStateException("The content to be deployed must be set for for deployments and re-deployments.");
        }
    }
}

