/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentDescription;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.UndeployDescription;
import org.wildfly.plugin.deployment.MatchPatternStrategy;
import org.wildfly.plugin.deployment.MojoDeploymentException;

public class MavenDeployment {
    private final File content;
    private final Set<String> serverGroups;
    private final String name;
    private final String runtimeName;
    private final Type type;
    private final String matchPattern;
    private final MatchPatternStrategy matchPatternStrategy;
    private final DeploymentManager deploymentManager;

    MavenDeployment(ModelControllerClient client, Set<String> serverGroups, File content, String name, String runtimeName, Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        this.content = content;
        this.serverGroups = serverGroups;
        this.name = name == null ? content.getName() : name;
        this.runtimeName = runtimeName;
        this.type = type;
        this.matchPattern = matchPattern;
        this.matchPatternStrategy = matchPatternStrategy;
        this.deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
    }

    public void execute() throws MojoDeploymentException {
        try {
            DeploymentResult result;
            switch (this.type) {
                case DEPLOY: {
                    result = this.deploymentManager.deploy(Deployment.of((File)this.content).setName(this.name).setRuntimeName(this.runtimeName).addServerGroups(this.serverGroups));
                    break;
                }
                case FORCE_DEPLOY: {
                    result = this.deploymentManager.forceDeploy(Deployment.of((File)this.content).setName(this.name).setRuntimeName(this.runtimeName).addServerGroups(this.serverGroups));
                    break;
                }
                case REDEPLOY: {
                    if (!this.deploymentManager.hasDeployment(this.name)) {
                        throw new MojoDeploymentException("Deployment '%s' not found, cannot redeploy", this.name);
                    }
                    result = this.deploymentManager.redeploy(Deployment.of((File)this.content).setName(this.name).setRuntimeName(this.runtimeName).addServerGroups(this.serverGroups));
                    break;
                }
                case UNDEPLOY: {
                    if (this.matchPattern == null) {
                        result = this.deploymentManager.undeploy(UndeployDescription.of((String)this.name).addServerGroups(this.serverGroups).setFailOnMissing(true));
                        break;
                    }
                    Set<UndeployDescription> matchedDeployments = this.findDeployments(true);
                    result = this.deploymentManager.undeploy(matchedDeployments);
                    break;
                }
                case UNDEPLOY_IGNORE_MISSING: {
                    if (this.matchPattern == null) {
                        result = this.deploymentManager.undeploy(UndeployDescription.of((String)this.name).addServerGroups(this.serverGroups).setFailOnMissing(false));
                        break;
                    }
                    Set<UndeployDescription> matchedDeployments = this.findDeployments(false);
                    result = this.deploymentManager.undeploy(matchedDeployments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type: " + (Object)((Object)this.type));
                }
            }
            if (!result.successful()) {
                throw new MojoDeploymentException("Failed %s deployment. Reason: %s", this.type.verb, result.getFailureMessage());
            }
        }
        catch (MojoDeploymentException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw new MojoDeploymentException(e, "Error %s %s. The operation was cancelled. This may be caused by the client being closed.", this.type.verb, this.name);
        }
        catch (Exception e) {
            throw new MojoDeploymentException(e, "Error %s %s", this.type.verb, this.name);
        }
    }

    public Type getType() {
        return this.type;
    }

    private Set<UndeployDescription> findDeployments(boolean failOnMissing) throws IOException {
        if (this.name == null && this.matchPattern == null) {
            throw new IllegalArgumentException("deploymentName and matchPattern are null. One of them must be set in order to find an existing deployment.");
        }
        TreeSet<UndeployDescription> matchedDeployments = new TreeSet<UndeployDescription>();
        Set deployments = this.deploymentManager.getDeployments();
        Pattern pattern = Pattern.compile(this.matchPattern);
        for (DeploymentDescription deployment : deployments) {
            boolean matchFound = false;
            String deploymentName = deployment.getName();
            if (!pattern.matcher(deploymentName).matches()) continue;
            if (this.serverGroups.isEmpty()) {
                matchFound = true;
                matchedDeployments.add(UndeployDescription.of((String)deploymentName).setFailOnMissing(failOnMissing));
            } else {
                UndeployDescription undeployDescription = UndeployDescription.of((String)deploymentName);
                for (String serverGroup : this.serverGroups) {
                    if (!deployment.getServerGroups().contains(serverGroup)) continue;
                    matchFound = true;
                    undeployDescription.addServerGroup(serverGroup);
                }
                if (matchFound) {
                    matchedDeployments.add(undeployDescription.setFailOnMissing(failOnMissing));
                }
            }
            if (!matchFound || this.matchPatternStrategy != MatchPatternStrategy.FIRST) continue;
            break;
        }
        if (this.matchPatternStrategy == MatchPatternStrategy.FAIL && matchedDeployments.size() > 1) {
            throw new RuntimeException(String.format("Deployment failed, found %d deployed artifacts for pattern '%s' (%s)", matchedDeployments.size(), this.matchPattern, matchedDeployments));
        }
        return matchedDeployments;
    }

    public static enum Type {
        DEPLOY("deploying"),
        FORCE_DEPLOY("deploying"),
        UNDEPLOY("undeploying"),
        UNDEPLOY_IGNORE_MISSING("undeploying"),
        REDEPLOY("redeploying");

        final String verb;

        private Type(String verb) {
            this.verb = verb;
        }
    }
}

