/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugin.deployment.AbstractDeployment;
import org.wildfly.plugin.deployment.MavenDeployment;
import org.wildfly.plugin.deployment.MojoDeploymentException;

@Mojo(name="undeploy-artifact", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public final class UndeployArtifactMojo
extends AbstractDeployment {
    @Parameter
    private String groupId;
    @Parameter
    private String artifactId;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true", property="undeploy.ignoreMissingDeployment")
    private boolean ignoreMissingDeployment;
    private File file;

    @Override
    public void validate(boolean isDomain) throws MojoDeploymentException {
        super.validate(isDomain);
        if (this.artifactId == null) {
            throw new MojoDeploymentException("undeploy-artifact must specify the artifactId");
        }
        if (this.groupId == null) {
            throw new MojoDeploymentException("undeploy-artifact must specify the groupId");
        }
        Set dependencies = this.project.getDependencyArtifacts();
        Artifact artifact = null;
        for (Artifact a : dependencies) {
            if (!Objects.equals(a.getArtifactId(), this.artifactId) || !Objects.equals(a.getGroupId(), this.groupId) || !Objects.equals(a.getClassifier(), this.classifier)) continue;
            artifact = a;
            break;
        }
        if (artifact == null) {
            throw new MojoDeploymentException("Could not resolve artifact to deploy %s:%s", this.groupId, this.artifactId);
        }
        this.file = artifact.getFile();
    }

    @Override
    protected File file() {
        return this.file;
    }

    @Override
    public String goal() {
        return "undeploy-artifact";
    }

    @Override
    public MavenDeployment.Type getType() {
        return this.ignoreMissingDeployment ? MavenDeployment.Type.UNDEPLOY_IGNORE_MISSING : MavenDeployment.Type.UNDEPLOY;
    }
}

