/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class Commands {
    @Parameter
    private boolean batch;
    @Parameter
    private List<String> commands = new ArrayList<String>();
    @Parameter
    private List<File> scripts = new ArrayList<File>();
    @Parameter
    private boolean offline = false;
    private final boolean failOnError;

    @Deprecated
    public Commands() {
        this.failOnError = true;
    }

    Commands(boolean batch, List<String> commands, List<File> scripts, boolean failOnError, boolean offline) {
        this.batch = batch;
        this.commands = commands;
        this.scripts = scripts;
        this.failOnError = failOnError;
        this.offline = offline;
    }

    public boolean isBatch() {
        return this.batch;
    }

    protected List<String> getCommands() {
        return new ArrayList<String>(this.commands);
    }

    protected List<File> getScripts() {
        return new ArrayList<File>(this.scripts);
    }

    protected boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public boolean hasScripts() {
        return this.scripts != null && !this.scripts.isEmpty();
    }

    public boolean isOffline() {
        return this.offline;
    }
}

