/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.core.ServerProcess;

@Named
@Singleton
public class OfflineCLIExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(String wildflyHome, Commands commands, Log log, OutputStream stdout, Map<String, String> systemProperties) throws IOException {
        try {
            if (commands.hasScripts()) {
                for (File f : commands.getScripts()) {
                    Path script2 = f.toPath();
                    log.info((CharSequence)("Executing script: " + script2));
                    int exitCode = this.executeInNewProcess(wildflyHome, script2, systemProperties, stdout);
                    if (exitCode == 0) continue;
                    return exitCode;
                }
            }
            if (!commands.hasCommands()) return 0;
            Path script = Files.createTempFile("wildfly-maven-plugin-cli-script", ".cli", new FileAttribute[0]);
            try {
                try (BufferedWriter writer = Files.newBufferedWriter(script, StandardCharsets.UTF_8, new OpenOption[0]);){
                    if (commands.isBatch()) {
                        writer.write("batch");
                        writer.newLine();
                    }
                    for (String cmd : commands.getCommands()) {
                        writer.write(cmd);
                        writer.newLine();
                    }
                    if (commands.isBatch()) {
                        writer.write("run-batch");
                        writer.newLine();
                    }
                }
                int exitCode = this.executeInNewProcess(wildflyHome, script, systemProperties, stdout);
                if (exitCode == 0) return 0;
                int n = exitCode;
                return n;
            }
            finally {
                Files.deleteIfExists(script);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeInNewProcess(String wildflyHome, Path scriptFile, Map<String, String> systemProperties, OutputStream stdout) throws InterruptedException, IOException {
        CliCommandBuilder builder = CliCommandBuilder.of((String)wildflyHome).setScriptFile(scriptFile);
        if (systemProperties != null) {
            systemProperties.forEach((key, value) -> builder.addJavaOption(String.format("-D%s=%s", key, value)));
        }
        ServerProcess process = ServerProcess.start((CommandBuilder)builder, Collections.singletonMap("JBOSS_HOME", wildflyHome), (OutputStream)stdout);
        try {
            int n = process.waitFor();
            return n;
        }
        finally {
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }
}

