/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.deployment.AbstractDeployment;
import org.wildfly.plugin.deployment.PackageType;

abstract class AbstractAppDeployment
extends AbstractDeployment {
    @Parameter(defaultValue="${project.build.directory}/", property="wildfly.deployment.targetDir")
    private File targetDir;
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(alias="check-packaging", property="wildfly.checkPackaging", defaultValue="true")
    private boolean checkPackaging;

    AbstractAppDeployment() {
    }

    @Override
    protected boolean skipExecution() {
        boolean skip = super.skipExecution();
        if (!skip) {
            PackageType packageType = PackageType.resolve(this.project);
            if (this.checkPackaging && packageType.isIgnored()) {
                this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", packageType.getPackaging()));
                skip = true;
            }
        }
        return skip;
    }

    @Override
    protected File file() {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return new File(this.targetDir, filename);
    }
}

