/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.server.ProcessDestroyTimer;
import org.wildfly.plugin.server.User;

public class AddUser {
    @Parameter
    private List<User> users;

    public void set(String value) {
        User user = new User();
        user.set(value);
        this.users = Collections.singletonList(user);
    }

    boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    void addUsers(Path wildflyHome, Path javaHome) throws IOException {
        if (this.users != null) {
            for (User user : this.users) {
                this.addUser(wildflyHome, user, javaHome);
            }
        }
    }

    private void addUser(Path wildflyHome, User user, Path javaHome) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaHome == null ? "java" : javaHome.resolve("bin").resolve("java").toString());
        cmd.add("-jar");
        cmd.add(wildflyHome.resolve("jboss-modules.jar").toString());
        cmd.add("-mp");
        cmd.add(wildflyHome.resolve("modules").toString());
        cmd.add("org.jboss.as.domain-add-user");
        cmd.add("-u");
        cmd.add(user.getUsername());
        cmd.add("-p");
        cmd.add(user.getPassword());
        cmd.add("-s");
        AddUser.setOptionalValue(cmd, "-a", user.isApplicationUser());
        AddUser.setOptionalValue(cmd, "-g", user.getGroups());
        AddUser.setOptionalValue(cmd, "-r", user.getRealm());
        ProcessBuilder processBuilder = new ProcessBuilder(cmd).inheritIO().directory(wildflyHome.toFile());
        processBuilder.environment().put("JBOSS_HOME", wildflyHome.toString());
        Process process = processBuilder.start();
        ProcessDestroyTimer shutdown = ProcessDestroyTimer.start(process, 30L);
        int returnValue = -1;
        try {
            returnValue = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (returnValue != 0) {
            throw new IllegalStateException("Could not add user");
        }
        shutdown.interrupt();
    }

    public String toString() {
        if (this.users == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(128);
        Iterator<User> iterator = this.users.iterator();
        while (iterator.hasNext()) {
            result.append(iterator.next());
            if (!iterator.hasNext()) continue;
            result.append(System.lineSeparator());
            result.append('\t');
        }
        return result.toString();
    }

    private static void setOptionalValue(Collection<String> cmd, String key, boolean value) {
        if (value) {
            cmd.add(key);
        }
    }

    private static void setOptionalValue(Collection<String> cmd, String key, String value) {
        if (value != null && !value.isEmpty()) {
            cmd.add(key);
            cmd.add(value);
        }
    }

    private static void setOptionalValue(Collection<String> cmd, String key, Iterable<String> value) {
        Iterator<String> iterator;
        if (value != null && (iterator = value.iterator()).hasNext()) {
            cmd.add(key);
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            cmd.add(sb.toString());
        }
    }
}

