/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugins.annotations.Parameter;

public class User {
    @Parameter(required=true)
    private String username;
    @Parameter(required=true)
    private String password;
    @Parameter
    private List<String> groups;
    @Parameter
    private String realm;
    @Parameter(alias="application-user", defaultValue="false")
    private boolean applicationUser;

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isApplicationUser() {
        return this.applicationUser;
    }

    public void set(String value) {
        if (value != null) {
            List<String> parts = User.splitAndTrim(value, ':');
            switch (parts.size()) {
                case 5: {
                    this.applicationUser = Boolean.parseBoolean(parts.get(4));
                }
                case 4: {
                    this.realm = parts.get(3);
                }
                case 3: {
                    String g = parts.get(2);
                    if (!g.isEmpty()) {
                        this.groups = User.splitAndTrim(g, ',');
                    }
                }
                case 2: {
                    this.username = parts.get(0);
                    this.password = parts.get(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Username and password are required parameters");
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password);
    }

    public String toString() {
        return "User{username=" + this.username + ", groups=" + this.groups + ", realm=" + this.realm + ", applicationUser=" + this.applicationUser + "}";
    }

    private static List<String> splitAndTrim(String value, char splitChar) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == splitChar) {
                result.add(sb.toString().trim());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(sb.toString().trim());
        }
        return result;
    }
}

