/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.net.URISyntaxException;
import java.net.URL;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractServerConnection
extends AbstractMojo {
    public static final String DEBUG_MESSAGE_NO_CREDS = "No username and password in settings.xml file - falling back to CLI entry";
    public static final String DEBUG_MESSAGE_NO_ID = "No <id> element was found in the POM - Getting credentials from CLI entry";
    public static final String DEBUG_MESSAGE_NO_SERVER_SECTION = "No <server> section was found for the specified id";
    public static final String DEBUG_MESSAGE_NO_SETTINGS_FILE = "No settings.xml file was found in this Mojo's execution context";
    public static final String DEBUG_MESSAGE_POM_HAS_CREDS = "Getting credentials from the POM";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_CREDS = "Found username and password in the settings.xml file";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_ID = "Found the server's id in the settings.xml file";
    @Parameter(property="wildfly.protocol")
    private String protocol;
    @Parameter(defaultValue="localhost", property="wildfly.hostname")
    private String hostname;
    @Parameter(defaultValue="9990", property="wildfly.port")
    private int port;
    @Parameter(property="wildfly.id")
    private String id;
    @Parameter(property="settings", readonly=true, required=true, defaultValue="${settings}")
    private Settings settings;
    @Parameter(property="wildfly.username")
    private String username;
    @Parameter(property="wildfly.password")
    private String password;
    @Parameter(property="wildfly.timeout", defaultValue="60")
    protected int timeout;
    @Parameter(alias="authentication-config", property="wildfly.authConfig")
    private URL authenticationConfig;
    @Inject
    private SettingsDecrypter settingsDecrypter;

    public abstract String goal();

    protected ModelControllerClient createClient() {
        return ModelControllerClient.Factory.create((ModelControllerClientConfiguration)this.getClientConfiguration());
    }

    protected synchronized MavenModelControllerClientConfiguration getClientConfiguration() {
        Log log = this.getLog();
        String username = this.username;
        String password = this.password;
        if (username == null && password == null) {
            if (this.id != null) {
                if (this.settings != null) {
                    Server server = this.settings.getServer(this.id);
                    if (server != null) {
                        log.debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_ID);
                        password = this.decrypt(server);
                        username = server.getUsername();
                        if (username != null && password != null) {
                            log.debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_CREDS);
                        } else {
                            log.debug((CharSequence)DEBUG_MESSAGE_NO_CREDS);
                        }
                    } else {
                        log.debug((CharSequence)DEBUG_MESSAGE_NO_SERVER_SECTION);
                    }
                } else {
                    log.debug((CharSequence)DEBUG_MESSAGE_NO_SETTINGS_FILE);
                }
            } else {
                log.debug((CharSequence)DEBUG_MESSAGE_NO_ID);
            }
        } else {
            log.debug((CharSequence)DEBUG_MESSAGE_POM_HAS_CREDS);
        }
        ModelControllerClientConfiguration.Builder builder = new ModelControllerClientConfiguration.Builder().setProtocol(this.protocol).setHostName(this.hostname).setPort(this.port).setConnectionTimeout(this.timeout * 1000);
        if (this.authenticationConfig != null) {
            try {
                builder.setAuthenticationConfigUri(this.authenticationConfig.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to create URI from " + this.authenticationConfig, e);
            }
        }
        return new MavenModelControllerClientConfiguration(builder.build(), username, password);
    }

    private String decrypt(Server server) {
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
        return decrypt.getServer().getPassword();
    }

    static {
        WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.logging.provider", (String)"slf4j");
    }
}

