/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.IOException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.deployment.AbstractAppDeployment;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class DeployMojo
extends AbstractAppDeployment {
    @Parameter(defaultValue="true", property="deploy.force")
    private boolean force;

    @Override
    public String goal() {
        return "deploy";
    }

    @Override
    protected DeploymentResult executeDeployment(DeploymentManager deploymentManager, Deployment deployment) throws IOException {
        if (this.force) {
            return deploymentManager.forceDeploy(deployment);
        }
        return deploymentManager.deploy(deployment);
    }
}

