/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.IOException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.deployment.AbstractAppDeployment;
import org.wildfly.plugin.deployment.MojoDeploymentException;

@Mojo(name="redeploy", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RedeployMojo
extends AbstractAppDeployment {
    @Override
    public String goal() {
        return "redeploy";
    }

    @Override
    protected DeploymentResult executeDeployment(DeploymentManager deploymentManager, Deployment deployment) throws IOException, MojoDeploymentException {
        if (!deploymentManager.hasDeployment(deployment.getName())) {
            throw new MojoDeploymentException("The deployment %s does not exist in the content repository and cannot be redeployed.", deployment.getName());
        }
        return deploymentManager.redeploy(deployment);
    }
}

