/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.util.function.Supplier;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.cli.BaseCommandConfiguration;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;

public class CommandConfiguration
extends BaseCommandConfiguration {
    private final Supplier<ModelControllerClient> client;
    private final Supplier<MavenModelControllerClientConfiguration> clientConfiguration;
    private final boolean fork;
    private final boolean offline;
    private final boolean autoReload;

    protected CommandConfiguration(AbstractBuilder<?> builder) {
        super(builder);
        this.client = builder.client;
        this.clientConfiguration = builder.clientConfiguration;
        this.fork = builder.fork;
        this.offline = builder.offline;
        this.autoReload = builder.autoReload;
    }

    public static Builder of(Supplier<ModelControllerClient> clientSupplier, Supplier<MavenModelControllerClientConfiguration> clientConfigurationSupplier) {
        return new Builder(clientSupplier, clientConfigurationSupplier);
    }

    public ModelControllerClient getClient() {
        return this.client.get();
    }

    public MavenModelControllerClientConfiguration getClientConfiguration() {
        return this.clientConfiguration.get();
    }

    public boolean isFork() {
        return this.fork;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isAutoReload() {
        return !this.offline && this.autoReload;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BaseCommandConfiguration.AbstractBuilder<T> {
        private final Supplier<ModelControllerClient> client;
        private final Supplier<MavenModelControllerClientConfiguration> clientConfiguration;
        private boolean fork;
        private boolean offline;
        private boolean autoReload;

        AbstractBuilder(Supplier<ModelControllerClient> clientSupplier, Supplier<MavenModelControllerClientConfiguration> clientConfigurationSupplier) {
            this.client = clientSupplier;
            this.clientConfiguration = clientConfigurationSupplier;
        }

        public T setFork(boolean fork) {
            this.fork = fork;
            return (T)((AbstractBuilder)this.builderInstance());
        }

        public T setOffline(boolean offline) {
            this.offline = offline;
            return (T)((AbstractBuilder)this.builderInstance());
        }

        public T setAutoReload(boolean autoReload) {
            this.autoReload = autoReload;
            return (T)((AbstractBuilder)this.builderInstance());
        }

        @Override
        public CommandConfiguration build() {
            return new CommandConfiguration(this);
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        Builder(Supplier<ModelControllerClient> clientSupplier, Supplier<MavenModelControllerClientConfiguration> clientConfigurationSupplier) {
            super(clientSupplier, clientConfigurationSupplier);
        }

        @Override
        protected Builder builderInstance() {
            return this;
        }
    }
}

