/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.ProvisioningBuilder;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.plugin.core.MavenJBossLogger;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.provision.ChannelConfiguration;
import org.wildfly.plugin.provision.ChannelMavenArtifactRepositoryManager;
import org.wildfly.plugin.tools.GalleonUtils;
import org.wildfly.plugin.tools.PluginProgressTracker;

abstract class AbstractProvisionServerMojo
extends AbstractMojo {
    @Component
    RepositorySystem repoSystem;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(required=false, alias="galleon-options")
    Map<String, String> galleonOptions = Collections.emptyMap();
    @Parameter(alias="offline-provisioning", defaultValue="false", property="wildfly.provisioning.offline")
    boolean offlineProvisioning;
    @Parameter(alias="log-provisioning-time", defaultValue="false", property="wildfly.provisioning.log.time")
    boolean logProvisioningTime;
    @Parameter(alias="record-provisioning-state", defaultValue="false", property="wildfly.provisioning.record.state")
    boolean recordProvisioningState;
    @Parameter(defaultValue="false", property="wildfly.provision.skip")
    private boolean skip;
    @Parameter(alias="provisioning-dir", property="wildfly.provisioning.dir", defaultValue="server")
    protected String provisioningDir;
    @Parameter(alias="overwrite-provisioned-server", defaultValue="false", property="wildfly.provisioning.overwrite-provisioned-server")
    private boolean overwriteProvisionedServer;
    @Parameter(required=false, alias="feature-packs", property="wildfly.provisioning.feature-packs")
    List<GalleonFeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="layers", required=false, property="wildfly.provisioning.layers")
    List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", required=false, property="wildfly.provisioning.layers.excluded")
    List<String> excludedLayers = Collections.emptyList();
    @Parameter(alias="provisioning-file", property="wildfly.provisioning.file", defaultValue="${project.basedir}/galleon/provisioning.xml")
    private File provisioningFile;
    @Parameter(alias="layers-configuration-file-name", property="wildfly.provisioning.layers.configuration.file.name", defaultValue="standalone.xml")
    String layersConfigurationFileName;
    @Parameter(alias="channels", property="wildfly.channels")
    List<ChannelConfiguration> channels;
    @Parameter(alias="dry-run")
    boolean dryRun;
    private Path wildflyDir;
    protected MavenRepoManager artifactResolver;

    AbstractProvisionServerMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.getGoal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"Dry run execution, no server will be provisioned.");
        }
        Path targetPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        this.wildflyDir = targetPath.resolve(this.provisioningDir).normalize();
        if (!this.overwriteProvisionedServer && Files.exists(this.wildflyDir, new LinkOption[0])) {
            this.getLog().info((CharSequence)String.format("A server already exists in " + String.valueOf(this.wildflyDir) + ", skipping " + this.getGoal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        this.enrichRepositories();
        if (this.channels == null || this.channels.isEmpty()) {
            this.artifactResolver = this.offlineProvisioning ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        } else {
            try {
                this.artifactResolver = new ChannelMavenArtifactRepositoryManager(this.channels, this.repoSystem, this.repoSession, this.repositories, this.getLog(), this.offlineProvisioning);
            }
            catch (MalformedURLException | UnresolvedMavenArtifactException ex) {
                throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
            }
        }
        if (!(Paths.get(this.provisioningDir, new String[0]).isAbsolute() || !targetPath.equals(this.wildflyDir) && this.wildflyDir.startsWith(targetPath))) {
            throw new MojoExecutionException("provisioning-dir " + this.provisioningDir + " must be an absolute path or a child directory relative to the project build directory.");
        }
        IoUtils.recursiveDelete((Path)this.wildflyDir);
        try {
            try {
                this.provisionServer(this.wildflyDir);
                if (!this.dryRun) {
                    if (this.artifactResolver instanceof ChannelMavenArtifactRepositoryManager) {
                        ((ChannelMavenArtifactRepositoryManager)this.artifactResolver).done(this.wildflyDir);
                    }
                    this.serverProvisioned(this.wildflyDir);
                }
            }
            catch (IOException | XMLStreamException | ProvisioningException ex) {
                throw new MojoExecutionException("Provisioning failed", (Exception)ex);
            }
        }
        finally {
            System.clearProperty("module.path");
        }
    }

    protected void enrichRepositories() throws MojoExecutionException {
        MavenRepositoriesEnricher.enrich((MavenSession)this.session, (MavenProject)this.project, this.repositories);
    }

    protected abstract String getGoal();

    protected abstract void serverProvisioned(Path var1) throws MojoExecutionException, MojoFailureException;

    private void provisionServer(Path home) throws ProvisioningException, MojoExecutionException, IOException, XMLStreamException {
        GalleonBuilder galleonBuilder = new GalleonBuilder();
        galleonBuilder.addArtifactResolver((RepositoryArtifactResolver)this.artifactResolver);
        GalleonProvisioningConfig config = this.buildGalleonConfig(galleonBuilder);
        ProvisioningBuilder builder = galleonBuilder.newProvisioningBuilder(config);
        try (Provisioning pm = builder.setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logProvisioningTime).setRecordState(this.recordProvisioningState).build();){
            if (this.dryRun) {
                Path targetPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
                Path file = targetPath.resolve(".wildfly-maven-plugin-provisioning.xml");
                this.getLog().info((CharSequence)("Dry-run execution, generating provisioning.xml file: " + String.valueOf(file)));
                pm.storeProvisioningConfig(config, file);
                return;
            }
            this.getLog().info((CharSequence)("Provisioning server in " + String.valueOf(home)));
            PluginProgressTracker.initTrackers((Provisioning)pm, (Logger)new MavenJBossLogger(this.getLog()));
            pm.provision(config);
            if (!Files.exists(home.resolve("standalone"), new LinkOption[0]) && !Files.exists(home.resolve("domain"), new LinkOption[0])) {
                this.getLog().error((CharSequence)("Invalid galleon provisioning, no server provisioned in " + String.valueOf(home) + ". Make sure that the list of Galleon feature-packs and Galleon layers are properly configured."));
                throw new MojoExecutionException("Invalid plugin configuration, no server provisioned.");
            }
            if (!this.recordProvisioningState) {
                Path file = home.resolve(".wildfly-maven-plugin-provisioning.xml");
                pm.storeProvisioningConfig(config, file);
            }
        }
    }

    protected GalleonProvisioningConfig buildGalleonConfig(GalleonBuilder galleonBuilder) throws MojoExecutionException, ProvisioningException {
        GalleonProvisioningConfig config;
        Path resolvedProvisioningFile = AbstractProvisionServerMojo.resolvePath(this.project, this.provisioningFile.toPath());
        boolean provisioningFileExists = Files.exists(resolvedProvisioningFile, new LinkOption[0]);
        if (this.featurePacks.isEmpty()) {
            if (provisioningFileExists) {
                this.getLog().info((CharSequence)("Provisioning server using " + String.valueOf(resolvedProvisioningFile) + " file."));
                try (Provisioning p = galleonBuilder.newProvisioningBuilder(resolvedProvisioningFile).build();){
                    config = p.loadProvisioningConfig(resolvedProvisioningFile);
                }
            } else {
                config = this.getDefaultConfig();
                if (config == null) {
                    throw new MojoExecutionException("No feature-pack has been configured, can't provision a server.");
                }
            }
        } else {
            if (provisioningFileExists) {
                this.getLog().warn((CharSequence)("Galleon provisioning file " + String.valueOf(this.provisioningFile) + " is ignored, plugin configuration is used."));
            }
            if (this.layers.isEmpty() && !"standalone.xml".equals(this.layersConfigurationFileName)) {
                throw new MojoExecutionException("layers-configuration-file-name has been set although no layers are defined.");
            }
            config = GalleonUtils.buildConfig((GalleonBuilder)galleonBuilder, this.featurePacks, this.layers, this.excludedLayers, this.galleonOptions, (String)this.layersConfigurationFileName);
        }
        return config;
    }

    protected GalleonProvisioningConfig getDefaultConfig() throws ProvisioningException {
        return GalleonUtils.buildDefaultConfig();
    }

    static Path resolvePath(MavenProject project, Path path) {
        if (!path.isAbsolute()) {
            path = Paths.get(project.getBasedir().getAbsolutePath(), new String[0]).resolve(path);
        }
        return path;
    }

    static {
        String provider = System.getProperty("org.jboss.logging.provider");
        if (provider == null || provider.isBlank()) {
            System.setProperty("org.jboss.logging.provider", "slf4j");
        }
    }
}

