/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.server.AbstractServerStartMojo;
import org.wildfly.plugin.server.ServerType;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartMojo
extends AbstractServerStartMojo {
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="domain-config", property="wildfly.domainConfig")
    private String domainConfig;
    @Parameter(alias="host-config", property="wildfly.hostConfig")
    private String hostConfig;
    @Parameter(alias="server-type", property="wildfly.server.type", defaultValue="STANDALONE")
    protected ServerType serverType;
    @Parameter(property="wildfly.stdout")
    private String stdout;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.debug((CharSequence)"Skipping server start");
            return;
        }
        try {
            this.startServer(this.serverType);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    @Override
    protected CommandBuilder createCommandBuilder(Path jbossHome) throws MojoExecutionException {
        if (this.serverType == ServerType.DOMAIN) {
            return this.createDomainCommandBuilder(jbossHome, this.domainConfig, this.hostConfig);
        }
        return this.createStandaloneCommandBuilder(jbossHome, this.serverConfig);
    }

    @Override
    protected StandardOutput standardOutput() throws IOException {
        return StandardOutput.parse(this.stdout, true);
    }

    @Override
    public String goal() {
        return "start";
    }
}

