/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliMessages;

public class RepositoryDefinition {
    public static List<Repository> from(List<String> repos) throws ArgumentParsingException {
        ArrayList<Repository> repositories = new ArrayList<Repository>(repos.size());
        for (int i = 0; i < repos.size(); ++i) {
            String text = repos.get(i);
            if (text.contains("::")) {
                String[] parts = text.split("::");
                if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty() || !RepositoryDefinition.isValidUrl(parts[1])) {
                    throw CliMessages.MESSAGES.invalidRepositoryDefinition(text);
                }
                repositories.add(new Repository(parts[0], parts[1]));
                continue;
            }
            if (!RepositoryDefinition.isValidUrl(text)) {
                throw CliMessages.MESSAGES.invalidRepositoryDefinition(text);
            }
            repositories.add(new Repository("temp-repo-" + i, text));
        }
        return repositories;
    }

    private static boolean isValidUrl(String text) {
        try {
            new URL(text);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

