/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager;

public class ArtifactChange {
    private final String oldVersion;
    private final String newVersion;
    private final String artifactName;
    private final Status status;

    public ArtifactChange(String oldVersion, String newVersion, String artifactName, Status status) {
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
        this.artifactName = artifactName;
        this.status = status;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getOldGav() {
        return this.getArtifactName() + ":" + this.getOldVersion();
    }

    public String getNewGav() {
        return this.getArtifactName() + ":" + this.getNewVersion();
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArtifactChange{");
        sb.append("oldVersion='").append(this.oldVersion).append('\'');
        sb.append(", newVersion='").append(this.newVersion).append('\'');
        sb.append(", artifactName='").append(this.artifactName).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append('}');
        return sb.toString();
    }

    public static enum Status {
        UPDATED,
        INSTALLED,
        REMOVED;

    }
}

