/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.galleon.ArtifactCache;

public class CachedVersionResolver
implements MavenVersionsResolver {
    private static final Logger LOG = Logger.getLogger((String)CachedVersionResolver.class.getName());
    private static final RepositoryListener NOOP_REPOSITORY_LISTENER = new AbstractRepositoryListener(){};
    private final MavenVersionsResolver fallbackResolver;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final ArtifactCache artifactCache;
    private final Logger log = Logger.getLogger(CachedVersionResolver.class);
    private final RepositoryListener listener;
    private final Function<ArtifactCoordinate, String> manifestVersionProvider;

    @Deprecated
    public CachedVersionResolver(MavenVersionsResolver fallbackResolver, ArtifactCache cache, RepositorySystem system, RepositorySystemSession session) {
        this(fallbackResolver, cache, system, session, a -> null);
    }

    public CachedVersionResolver(MavenVersionsResolver fallbackResolver, ArtifactCache cache, RepositorySystem system, RepositorySystemSession session, Function<ArtifactCoordinate, String> manifestVersionProvider) {
        this.fallbackResolver = fallbackResolver;
        this.system = system;
        this.session = session;
        this.artifactCache = cache;
        this.manifestVersionProvider = manifestVersionProvider;
        this.listener = session.getRepositoryListener() != null ? session.getRepositoryListener() : NOOP_REPOSITORY_LISTENER;
    }

    public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
        return this.fallbackResolver.getAllVersions(groupId, artifactId, extension, classifier);
    }

    public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Optional<File> path = this.artifactCache.getArtifact(groupId, artifactId, extension, classifier, version);
        if (path.isEmpty()) {
            return this.fallbackResolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
        }
        if (this.installArtifactLocally(groupId, artifactId, extension, classifier, version, path.get())) {
            return path.get();
        }
        return this.fallbackResolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
    }

    public List<File> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
        ArrayList<Function<List, File>> res = new ArrayList<Function<List, File>>(coordinates.size());
        ArrayList<ArtifactCoordinate> missingArtifacts = new ArrayList<ArtifactCoordinate>();
        int index = 0;
        for (ArtifactCoordinate coordinate : coordinates) {
            int i;
            Optional<File> path = this.artifactCache.getArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getExtension(), coordinate.getClassifier(), coordinate.getVersion());
            if (path.isEmpty()) {
                i = index++;
                res.add(list -> (File)list.get(i));
                missingArtifacts.add(coordinate);
                continue;
            }
            if (this.installArtifactLocally(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getExtension(), coordinate.getClassifier(), coordinate.getVersion(), path.get())) {
                res.add(list -> (File)path.get());
                continue;
            }
            i = index++;
            res.add(list -> (File)list.get(i));
            missingArtifacts.add(coordinate);
        }
        List resolvedFromMaven = this.fallbackResolver.resolveArtifacts(missingArtifacts);
        return res.stream().map(f -> (File)f.apply(resolvedFromMaven)).collect(Collectors.toList());
    }

    public List<URL> resolveChannelMetadata(List<? extends ChannelMetadataCoordinate> manifestCoords) throws UnresolvedMavenArtifactException {
        try {
            return this.fallbackResolver.resolveChannelMetadata(manifestCoords);
        }
        catch (ArtifactTransferException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to resolve manifests, attempting to fall back to the cache.");
            }
            URL[] cachedMetadata = new URL[manifestCoords.size()];
            block4: for (ArtifactCoordinate a : e.getUnresolvedArtifacts()) {
                String version = this.manifestVersionProvider.apply(a);
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Last used version for manifest %s is %s.", (Object)a, (Object)version);
                }
                if (version == null) {
                    throw e;
                }
                Optional<File> artifact = this.artifactCache.getArtifact(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), version);
                if (artifact.isPresent()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Found cached manifest for %s.", (Object)a);
                    }
                    this.log.warnf("Unable to resolve manifest for channel %s, no updates will be resolved for this channel.", (Object)a);
                    this.listener.artifactResolved(new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.ARTIFACT_RESOLVED).setArtifact((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), version, null, artifact.get())).build());
                    try {
                        for (int i = 0; i < manifestCoords.size(); ++i) {
                            ChannelMetadataCoordinate coord = manifestCoords.get(i);
                            if (!coord.getGroupId().equals(a.getGroupId()) || !coord.getArtifactId().equals(a.getArtifactId()) || !coord.getClassifier().equals(a.getClassifier()) || !coord.getExtension().equals(a.getExtension())) continue;
                            cachedMetadata[i] = artifact.get().toURI().toURL();
                            continue block4;
                        }
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                throw e;
            }
            for (int i = 0; i < cachedMetadata.length; ++i) {
                if (cachedMetadata[i] != null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Retrying resolution of manifest %s.", (Object)cachedMetadata[i]);
                }
                cachedMetadata[i] = (URL)this.fallbackResolver.resolveChannelMetadata(List.of(manifestCoords.get(i))).get(0);
            }
            return Arrays.asList(cachedMetadata);
        }
    }

    public String getMetadataReleaseVersion(String groupId, String artifactId) {
        return this.fallbackResolver.getMetadataReleaseVersion(groupId, artifactId);
    }

    public String getMetadataLatestVersion(String groupId, String artifactId) {
        return this.fallbackResolver.getMetadataLatestVersion(groupId, artifactId);
    }

    private boolean installArtifactLocally(String groupId, String artifactId, String extension, String classifier, String version, File path) {
        try {
            InstallRequest request = new InstallRequest();
            request.setArtifacts(List.of(new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, path)));
            this.system.install(this.session, request);
            return true;
        }
        catch (InstallationException e) {
            this.log.debug((Object)"Unable to install cached artifact into LRM, falling back to resolver.", (Throwable)e);
            return false;
        }
    }
}

