/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.BufferedReader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Stream;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.ChannelResolvable;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.galleon.MavenArtifactMapper;

public class ChannelMavenArtifactRepositoryManager
implements MavenRepoManager,
ChannelResolvable {
    private static final Logger LOG = Logger.getLogger(ChannelMavenArtifactRepositoryManager.class);
    private static final String REQUIRE_CHANNEL_FOR_ALL_ARTIFACT = "org.wildfly.plugins.galleon.all.artifact.requires.channel.resolution";
    private final ChannelSession channelSession;
    private final ChannelManifest manifest;

    public ChannelMavenArtifactRepositoryManager(ChannelSession channelSession) {
        this.channelSession = channelSession;
        this.manifest = null;
    }

    public ChannelMavenArtifactRepositoryManager(ChannelSession channelSession, ChannelManifest manifest) {
        this.channelSession = channelSession;
        this.manifest = manifest;
    }

    public void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        MavenArtifact result;
        if (this.manifest == null) {
            try {
                result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
            }
            catch (ArtifactTransferException e) {
                throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (NoStreamFoundException e) {
                if (this.requiresChannel(artifact)) {
                    throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
                }
                if (artifact.getVersion() == null) {
                    throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
                }
                try {
                    result = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
                }
                catch (ArtifactTransferException ex) {
                    throw new MavenUniverseException(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        } else {
            try {
                result = this.resolveFromPreparedManifest(artifact);
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        MavenArtifactMapper.resolve(artifact, result);
    }

    private boolean fpRequireChannel(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws Exception {
        boolean requireChannel;
        block17: {
            requireChannel = false;
            if (artifact.getVersion() != null && artifact.getExtension() != null && artifact.getExtension().equalsIgnoreCase("zip")) {
                if (artifact.getVersion().equals(artifact.getExtension())) {
                    return true;
                }
                MavenArtifact mavenArtifact = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
                try {
                    FeaturePackDescriber.readSpec((Path)mavenArtifact.getFile().toPath());
                }
                catch (ProvisioningException ex) {
                    return requireChannel;
                }
                try (FileSystem fs = ZipUtils.newFileSystem((Path)mavenArtifact.getFile().toPath());){
                    Path resPath = fs.getPath("resources", new String[0]);
                    Path wfRes = resPath.resolve("wildfly");
                    Path channelPropsPath = wfRes.resolve("wildfly-channel.properties");
                    if (!Files.exists(channelPropsPath, new LinkOption[0])) break block17;
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(channelPropsPath);){
                        props.load(reader);
                    }
                    String resolution = props.getProperty("resolution");
                    if (resolution != null) {
                        requireChannel = "REQUIRED".equals(resolution) || "REQUIRED_FP_ONLY".equals(resolution);
                    }
                }
            }
        }
        return requireChannel;
    }

    private MavenArtifact resolveFromPreparedManifest(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        MavenArtifact result;
        Optional<DefaultArtifact> found = this.manifest.findStreamFor(artifact.getGroupId(), artifact.getArtifactId()).map(this::streamToArtifact);
        if (found.isPresent()) {
            result = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), found.get().getVersion());
        } else if (this.isUniverseOrProducerArtifact(artifact.getArtifactId())) {
            result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
        } else {
            throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + artifact.getCoordsAsString() + "]");
        }
        return result;
    }

    private boolean requiresChannel(org.jboss.galleon.universe.maven.MavenArtifact artifact) {
        if (artifact.getVersion() == null || artifact.getVersion().isEmpty()) {
            return true;
        }
        boolean requireChannel = Boolean.parseBoolean((String)artifact.getMetadata().get(REQUIRE_CHANNEL_FOR_ALL_ARTIFACT));
        try {
            return requireChannel || this.fpRequireChannel(artifact);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void resolveAll(Collection<org.jboss.galleon.universe.maven.MavenArtifact> artifacts) throws MavenUniverseException {
        if (this.manifest == null) {
            List<org.jboss.galleon.universe.maven.MavenArtifact> artifactsRequiringChannels = artifacts.stream().filter(a -> this.requiresChannel((org.jboss.galleon.universe.maven.MavenArtifact)a)).collect(Collectors.toList());
            List<org.jboss.galleon.universe.maven.MavenArtifact> artifactsNotRequiringChannels = artifacts.stream().filter(a -> !this.requiresChannel((org.jboss.galleon.universe.maven.MavenArtifact)a)).collect(Collectors.toList());
            MavenArtifactMapper mapper = new MavenArtifactMapper(artifactsRequiringChannels);
            List channelArtifacts = this.channelSession.resolveMavenArtifacts(mapper.toChannelArtifacts());
            mapper.applyResolution(channelArtifacts);
            MavenArtifactMapper mapperNotRequiringChannels = new MavenArtifactMapper(artifactsNotRequiringChannels);
            this.resolveArtifactsWithFallbackVersions(mapperNotRequiringChannels, mapperNotRequiringChannels.toChannelArtifacts());
        } else {
            MavenArtifactMapper mapper = new MavenArtifactMapper(artifacts);
            List<ArtifactCoordinate> coordinates = this.toResolvableCoordinates(mapper.toChannelArtifacts());
            List channelArtifacts = this.channelSession.resolveDirectMavenArtifacts(coordinates);
            mapper.applyResolution(channelArtifacts);
            for (org.jboss.galleon.universe.maven.MavenArtifact artifact : artifacts) {
                if (artifact.getPath() != null) continue;
                if (this.isUniverseOrProducerArtifact(artifact.getArtifactId())) {
                    MavenArtifact result = this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null);
                    MavenArtifactMapper.resolve(artifact, result);
                    continue;
                }
                throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + artifact.getCoordsAsString() + "]");
            }
        }
    }

    private void resolveArtifactsWithFallbackVersions(MavenArtifactMapper mapperNotRequiringChannels, List<ArtifactCoordinate> coordinates) throws MavenUniverseException {
        try {
            List channelArtifacts = this.channelSession.resolveMavenArtifacts(coordinates);
            if (LOG.isDebugEnabled()) {
                channelArtifacts.forEach(a -> LOG.debugf("Installing artifact [%s:%s:%s] from channel [%s]", new Object[]{a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getChannelName().orElse("Unknown")}));
            }
            mapperNotRequiringChannels.applyResolution(channelArtifacts);
        }
        catch (ArtifactTransferException e) {
            throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (NoStreamFoundException e) {
            this.handleMissingStreams(mapperNotRequiringChannels, coordinates, (UnresolvedMavenArtifactException)((Object)e));
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void handleMissingStreams(MavenArtifactMapper mapperNotRequiringChannels, List<ArtifactCoordinate> coordinates, UnresolvedMavenArtifactException e) throws MavenUniverseException {
        Set unresolvedArtifacts = e.getUnresolvedArtifacts();
        for (ArtifactCoordinate a : unresolvedArtifacts) {
            List<org.jboss.galleon.universe.maven.MavenArtifact> missingArtifacts = mapperNotRequiringChannels.get(new ArtifactCoordinate(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), a.getVersion()));
            for (org.jboss.galleon.universe.maven.MavenArtifact missingArtifact : missingArtifacts) {
                if (missingArtifact.getVersion() == null) {
                    throw new MavenUniverseException(e.getLocalizedMessage(), (Throwable)e);
                }
                MavenArtifact mavenArtifact = this.channelSession.resolveDirectMavenArtifact(missingArtifact.getGroupId(), missingArtifact.getArtifactId(), missingArtifact.getExtension(), missingArtifact.getClassifier(), missingArtifact.getVersion());
                missingArtifact.setPath(mavenArtifact.getFile().toPath());
            }
        }
        ArrayList<ArtifactCoordinate> requests = new ArrayList<ArtifactCoordinate>();
        for (ArtifactCoordinate a : coordinates) {
            if (unresolvedArtifacts.contains(new ArtifactCoordinate(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), ""))) continue;
            requests.add(a);
        }
        this.resolveArtifactsWithFallbackVersions(mapperNotRequiringChannels, requests);
    }

    private List<ArtifactCoordinate> toResolvableCoordinates(List<ArtifactCoordinate> artifactCoordinates) throws MavenUniverseException {
        ArrayList<ArtifactCoordinate> coordinates = new ArrayList<ArtifactCoordinate>();
        for (ArtifactCoordinate coord : artifactCoordinates) {
            Optional<DefaultArtifact> found = this.manifest.findStreamFor(coord.getGroupId(), coord.getArtifactId()).map(this::streamToArtifact);
            if (found.isPresent()) {
                coordinates.add(new ArtifactCoordinate(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), found.get().getVersion()));
                continue;
            }
            throw new MavenUniverseException(ProsperoLogger.ROOT_LOGGER.unableToResolve() + " [" + coord.getGroupId() + ":" + coord.getGroupId() + ":" + coord.getExtension() + "]");
        }
        return coordinates;
    }

    private boolean isUniverseOrProducerArtifact(String artifactId) {
        return artifactId.equals("community-universe") || artifactId.equals("wildfly-producers");
    }

    private DefaultArtifact streamToArtifact(Stream s) {
        return new DefaultArtifact(s.getGroupId(), s.getArtifactId(), "jar", s.getVersion());
    }

    public boolean isResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isLatestVersionResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        this.resolve(artifact);
    }

    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        this.resolve(artifact);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        return this.getLatestVersion(artifact, null, null, null);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        return this.getLatestVersion(artifact, lowestQualifier, null, null);
    }

    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        try {
            return this.channelSession.resolveMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), null).getVersion();
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new MavenUniverseException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void install(org.jboss.galleon.universe.maven.MavenArtifact artifact, Path path) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ChannelManifest resolvedChannel() {
        return this.channelSession.getRecordedChannel();
    }
}

