/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.installation.git;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Diff;
import org.wildfly.prospero.api.FeatureChange;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.installation.git.GitStorage;

class FeatureChangeParser
implements GitStorage.Parser<FeatureChange> {
    FeatureChangeParser() {
    }

    @Override
    public List<FeatureChange> parse(Path changed, Path base) throws IOException, MetadataException {
        ProvisioningConfig oldConfig;
        ProvisioningConfig newConfig;
        ArrayList<FeatureChange> featureChanges = new ArrayList<FeatureChange>();
        try {
            newConfig = FeatureChangeParser.parseProvisioningConfig(changed);
            oldConfig = FeatureChangeParser.parseProvisioningConfig(base);
        }
        catch (ProvisioningException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToParseConfiguration(changed.resolve("provisioning_record.xml"), e);
        }
        Set oldFeatureNames = oldConfig.getFeaturePackDeps().stream().map(c -> c.getLocation().toString()).collect(Collectors.toSet());
        Set newFeatureNames = newConfig.getFeaturePackDeps().stream().map(c -> c.getLocation().toString()).collect(Collectors.toSet());
        HashSet addedFeatureNames = new HashSet(newFeatureNames);
        addedFeatureNames.removeAll(oldFeatureNames);
        for (Object addedFeatureName : addedFeatureNames) {
            featureChanges.add(new FeatureChange(FeatureChange.Type.FEATURE, (String)addedFeatureName, Diff.Status.ADDED, new Diff[0]));
        }
        HashSet removedFeatureNames = new HashSet(oldFeatureNames);
        removedFeatureNames.removeAll(newFeatureNames);
        for (String removedFeatureName : removedFeatureNames) {
            featureChanges.add(new FeatureChange(FeatureChange.Type.FEATURE, removedFeatureName, Diff.Status.REMOVED, new Diff[0]));
        }
        Set oldConfigs = oldConfig.getDefinedConfigs().stream().map(ConfigModel::getId).collect(Collectors.toSet());
        Set newConfigs = newConfig.getDefinedConfigs().stream().map(ConfigModel::getId).collect(Collectors.toSet());
        HashSet modifiedConfigs = new HashSet(newConfigs);
        modifiedConfigs.retainAll(oldConfigs);
        for (Object cfg : modifiedConfigs) {
            FeatureChangeParser.createConfigModelDiff(newConfig, oldConfig, (ConfigId)cfg).map(featureChanges::add);
        }
        HashSet addedConfigs = new HashSet(newConfigs);
        addedConfigs.removeAll(oldConfigs);
        for (ConfigId cfg : addedConfigs) {
            FeatureChangeParser.createConfigModelDiff(newConfig, null, cfg).map(featureChanges::add);
        }
        HashSet removedConfigs = new HashSet(oldConfigs);
        removedConfigs.removeAll(newConfigs);
        for (ConfigId cfg : removedConfigs) {
            FeatureChangeParser.createConfigModelDiff(null, oldConfig, cfg).map(featureChanges::add);
        }
        return featureChanges;
    }

    private static ProvisioningConfig parseProvisioningConfig(Path changed) throws ProvisioningException {
        if (changed == null || !Files.exists(changed.resolve("provisioning_record.xml"), new LinkOption[0])) {
            return ProvisioningConfig.builder().build();
        }
        return ProvisioningXmlParser.parse((Path)changed.resolve("provisioning_record.xml"));
    }

    private static Optional<FeatureChange> createConfigModelDiff(ProvisioningConfig newConfig, ProvisioningConfig oldConfig, ConfigId cfg) {
        Set newLayers;
        ArrayList<FeatureChange> configChanges = new ArrayList<FeatureChange>();
        ConfigModel oldCfgModel = oldConfig == null ? null : oldConfig.getDefinedConfig(cfg);
        ConfigModel newCfgModel = newConfig == null ? null : newConfig.getDefinedConfig(cfg);
        Set oldLayers = oldCfgModel == null ? Collections.emptySet() : oldCfgModel.getIncludedLayers();
        Set set = newLayers = newCfgModel == null ? Collections.emptySet() : newCfgModel.getIncludedLayers();
        if (oldLayers.equals(newLayers)) {
            return Optional.empty();
        }
        String oldConfigId = oldCfgModel == null ? null : oldCfgModel.getModel() + ":" + oldCfgModel.getName();
        String newConfigId = newCfgModel == null ? null : newCfgModel.getModel() + ":" + newCfgModel.getName();
        configChanges.add(new FeatureChange(FeatureChange.Type.LAYERS, FeatureChangeParser.serialize(oldLayers), FeatureChangeParser.serialize(newLayers)));
        Diff.Status status = newConfig == null ? Diff.Status.REMOVED : (oldConfig == null ? Diff.Status.ADDED : Diff.Status.MODIFIED);
        return Optional.of(new FeatureChange(FeatureChange.Type.CONFIG, oldConfigId == null ? newConfigId : oldConfigId, status, (Diff[])configChanges.toArray(new FeatureChange[0])));
    }

    private static String serialize(Set<String> oldLayers) {
        if (oldLayers.isEmpty()) {
            return null;
        }
        return StringUtils.join(oldLayers, (String)", ");
    }
}

